/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ViaListener;
import com.djrapitops.extension.ViaVersionStorage;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import us.myles.ViaVersion.api.ViaAPI;

public class ViaBukkitVersionListener
implements Listener,
ViaListener {
    private final ViaAPI viaAPI;
    private final ViaVersionStorage storage;
    private final Plugin plugin;

    ViaBukkitVersionListener(ViaAPI viaAPI, ViaVersionStorage storage) {
        this.viaAPI = viaAPI;
        this.storage = storage;
        this.plugin = Bukkit.getPluginManager().getPlugin("Plan");
    }

    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(PlayerJoinEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        int playerVersion = this.viaAPI.getPlayerVersion(uuid);
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                this.storage.storeProtocolVersion(uuid, playerVersion);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        });
    }
}

