/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ViaListener;
import com.djrapitops.extension.ViaVersionStorage;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import us.myles.ViaVersion.api.ViaAPI;

public class ViaSpongeVersionListener
implements ViaListener {
    private final ViaAPI viaAPI;
    private final ViaVersionStorage storage;
    private final PluginContainer plugin;

    ViaSpongeVersionListener(ViaAPI viaAPI, ViaVersionStorage storage) {
        this.viaAPI = viaAPI;
        this.storage = storage;
        this.plugin = (PluginContainer)Sponge.getPluginManager().getPlugin("Plan").orElseThrow(IllegalStateException::new);
    }

    @Override
    public void register() {
        Sponge.getGame().getEventManager().registerListeners((Object)this.plugin, (Object)this);
    }

    @Listener(order=Order.LAST)
    public void onJoin(ClientConnectionEvent.Join event) {
        UUID uuid = event.getTargetEntity().getUniqueId();
        int playerVersion = this.viaAPI.getPlayerVersion(uuid);
        Sponge.getGame().getScheduler().createTaskBuilder().async().execute(() -> {
            try {
                this.storage.storeProtocolVersion(uuid, playerVersion);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }).submit((Object)this.plugin);
    }
}

