/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ViaListener;
import com.djrapitops.extension.ViaVersionStorage;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.util.UUID;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;

@PluginInfo(name="ViaVersion", iconName="gamepad", iconFamily=Family.SOLID, color=Color.LIGHT_GREEN)
public abstract class ViaVersionExtension
implements DataExtension {
    protected final ViaVersionStorage storage;

    public ViaVersionExtension(ViaVersionStorage storage) {
        this.storage = storage;
    }

    public abstract ViaListener getListener();

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_JOIN, CallEvents.PLAYER_LEAVE, CallEvents.SERVER_PERIODICAL};
    }

    @StringProvider(text="Last Join Version", description="Version used last time the player joined", iconName="signal", iconColor=Color.LIGHT_GREEN, showInPlayerTable=true)
    public String protocolVersion(UUID playerUUID) {
        return this.getProtocolVersionString(this.storage.getProtocolVersion(playerUUID));
    }

    private String getProtocolVersionString(int version) {
        return version != -1 ? ProtocolVersion.getProtocol((int)version).getName() : "Not Yet Known";
    }

    @TableProvider(tableColor=Color.LIGHT_GREEN)
    public Table protocolTable() {
        Table.Factory table = Table.builder().columnOne("Version", Icon.called("signal").build()).columnTwo("Users", Icon.called("users").build());
        this.storage.getProtocolVersionCounts().entrySet().stream().sorted((one, two) -> Integer.compare((Integer)two.getValue(), (Integer)one.getValue())).forEach(entry -> table.addRow(this.getProtocolVersionString((Integer)entry.getKey()), entry.getValue()));
        return table.build();
    }
}

