/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.extension.ViaVersionBukkitExtension;
import com.djrapitops.extension.ViaVersionBungeeExtension;
import com.djrapitops.extension.ViaVersionExtension;
import com.djrapitops.extension.ViaVersionSpongeExtension;
import com.djrapitops.plan.extension.Caller;
import com.djrapitops.plan.extension.DataExtension;
import java.util.Optional;

public class ViaVersionExtensionFactory {
    private ViaVersionExtension extension;

    private boolean isAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public Optional<DataExtension> createExtension() {
        try {
            this.extension = this.createNewExtension();
            return Optional.ofNullable(this.extension);
        }
        catch (IllegalStateException noSponge) {
            return Optional.empty();
        }
    }

    public void registerListener(Caller caller) {
        this.extension.getListener().register();
    }

    private ViaVersionExtension createNewExtension() {
        if (this.isAvailable("us.myles.ViaVersion.ViaVersionPlugin")) {
            return new ViaVersionBukkitExtension();
        }
        if (this.isAvailable("us.myles.ViaVersion.BungeePlugin")) {
            return new ViaVersionBungeeExtension();
        }
        if (this.isAvailable("us.myles.ViaVersion.SpongePlugin")) {
            return new ViaVersionSpongeExtension();
        }
        return null;
    }
}

