/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension;

import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.query.QueryService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ViaVersionStorage {
    private final QueryService queryService = QueryService.getInstance();

    public ViaVersionStorage() {
        this.createTable();
        this.queryService.subscribeDataClearEvent(this::recreateTable);
        this.queryService.subscribeToPlayerRemoveEvent(this::removePlayer);
    }

    private void createTable() {
        String dbType = this.queryService.getDBType();
        boolean sqlite = dbType.equalsIgnoreCase("SQLITE");
        String sql = "CREATE TABLE IF NOT EXISTS plan_version_protocol (id int " + (sqlite ? "PRIMARY KEY" : "NOT NULL AUTO_INCREMENT") + ',' + "uuid varchar(36) NOT NULL UNIQUE,protocol_version int NOT NULL" + (sqlite ? "" : ",PRIMARY KEY (id)") + ')';
        this.queryService.execute(sql, PreparedStatement::execute);
    }

    private void dropTable() {
        this.queryService.execute("DROP TABLE IF EXISTS plan_version_protocol", PreparedStatement::execute);
    }

    private void recreateTable() {
        this.dropTable();
        this.createTable();
    }

    private void removePlayer(UUID playerUUID) {
        this.queryService.execute("DELETE FROM plan_version_protocol WHERE uuid=?", statement -> {
            statement.setString(1, playerUUID.toString());
            statement.execute();
        });
    }

    public void storeProtocolVersion(UUID uuid, int version) throws ExecutionException {
        String update = "UPDATE plan_version_protocol SET protocol_version=? WHERE uuid=?";
        String insert = "INSERT INTO plan_version_protocol (protocol_version, uuid) VALUES (?, ?)";
        AtomicBoolean updated = new AtomicBoolean(false);
        try {
            this.queryService.execute(update, statement -> {
                statement.setInt(1, version);
                statement.setString(2, uuid.toString());
                updated.set(statement.executeUpdate() > 0);
            }).get();
            if (!updated.get()) {
                this.queryService.execute(insert, statement -> {
                    statement.setInt(1, version);
                    statement.setString(2, uuid.toString());
                    statement.execute();
                });
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getProtocolVersion(UUID uuid) {
        String sql = "SELECT protocol_version FROM plan_version_protocol WHERE uuid=?";
        return this.queryService.query(sql, statement -> {
            statement.setString(1, uuid.toString());
            try (ResultSet set = statement.executeQuery();){
                Integer n = set.next() ? set.getInt("protocol_version") : -1;
                return n;
            }
        });
    }

    public Map<Integer, Integer> getProtocolVersionCounts() {
        UUID serverUUID = this.queryService.getServerUUID().orElseThrow(NotReadyException::new);
        String sql = "SELECT protocol_version, COUNT(1) as count FROM plan_version_protocol INNER JOIN plan_user_info on plan_version_protocol.uuid=plan_user_info.uuid WHERE plan_user_info.server_uuid=? GROUP BY protocol_version";
        return this.queryService.query("SELECT protocol_version, COUNT(1) as count FROM plan_version_protocol INNER JOIN plan_user_info on plan_version_protocol.uuid=plan_user_info.uuid WHERE plan_user_info.server_uuid=? GROUP BY protocol_version", statement -> {
            statement.setString(1, serverUUID.toString());
            try (ResultSet set = statement.executeQuery();){
                HashMap<Integer, Integer> versions = new HashMap<Integer, Integer>();
                while (set.next()) {
                    versions.put(set.getInt("protocol_version"), set.getInt("count"));
                }
                HashMap<Integer, Integer> hashMap = versions;
                return hashMap;
            }
        });
    }
}

