/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.extension.minigames;

import com.comze_instancelabs.minigamesapi.sql.MainSQL;
import com.djrapitops.extension.FakePlayer;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.icon.Color;
import java.util.UUID;
import org.bukkit.entity.Player;

public abstract class MinigameLibExtension
implements DataExtension {
    private final MainSQL sql;

    public MinigameLibExtension(MainSQL sql) {
        this.sql = sql;
    }

    @Override
    public CallEvents[] callExtensionMethodsOn() {
        return new CallEvents[]{CallEvents.PLAYER_LEAVE};
    }

    @NumberProvider(text="Wins", description="How many wins the player has", priority=10, iconName="trophy", iconColor=Color.AMBER, showInPlayerTable=true)
    public long wins(UUID playerUUID) {
        return this.sql.getWins((Player)new FakePlayer(playerUUID));
    }

    @NumberProvider(text="Points", description="How many points the player has", priority=9, iconName="plus", iconColor=Color.GREEN)
    public long points(UUID playerUUID) {
        return this.sql.getPoints((Player)new FakePlayer(playerUUID));
    }

    @NumberProvider(text="Game Points", description="How many game points the player has", priority=9, iconName="plus", iconColor=Color.GREEN)
    public long gamePoints(UUID playerUUID) {
        return this.sql.getGamePoints((Player)new FakePlayer(playerUUID));
    }
}

