/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.Plan;
import com.djrapitops.plan.utilities.metrics.bukkit.Metrics;
import com.djrapitops.plugin.api.Check;
import org.bukkit.plugin.Plugin;

public class BStatsBukkit {
    private final Plan plugin;
    private Metrics metrics;

    public BStatsBukkit(Plan plugin) {
        this.plugin = plugin;
    }

    public void registerMetrics() {
        if (this.metrics == null) {
            this.metrics = new Metrics((Plugin)this.plugin);
        }
        this.registerConfigSettingGraphs();
    }

    private void registerConfigSettingGraphs() {
        String serverType = this.plugin.getServer().getName();
        if ("CraftBukkit".equals(serverType) && Check.isSpigotAvailable()) {
            serverType = "Spigot";
        }
        String databaseType = this.plugin.getSystem().getDatabaseSystem().getDatabase().getType().getName();
        this.addStringSettingPie("server_type", serverType);
        this.addStringSettingPie("database_type", databaseType);
    }

    protected void addStringSettingPie(String id, String setting) {
        this.metrics.addCustomChart(new Metrics.SimplePie(id, () -> setting));
    }
}

