/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.PlanBungee;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.utilities.metrics.bungeecord.Metrics;
import java.util.function.Supplier;

public class BStatsBungee {
    private final PlanBungee plugin;
    private final Database database;
    private Metrics metrics;

    public BStatsBungee(PlanBungee plugin, Database database) {
        this.plugin = plugin;
        this.database = database;
    }

    public void registerMetrics() {
        if (this.metrics == null) {
            this.metrics = new Metrics(this.plugin);
        }
        this.registerConfigSettingGraphs();
    }

    private void registerConfigSettingGraphs() {
        this.addStringSettingPie("server_type", () -> this.plugin.getProxy().getName());
        this.addStringSettingPie("database_type", () -> this.database.getType().getName());
        this.addStringSettingPie("network_servers", () -> String.valueOf(this.database.query(ServerQueries.fetchPlanServerInformationCollection()).size()));
    }

    protected void addStringSettingPie(String id, Supplier<String> setting) {
        this.metrics.addCustomChart(new Metrics.SimplePie(id, setting::get));
    }
}

