/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.gathering.ServerShutdownSave;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.utilities.java.Reflection;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class BukkitServerShutdownSave
extends ServerShutdownSave {
    @Inject
    public BukkitServerShutdownSave(Locale locale, DBSystem dbSystem, PluginLogger logger, ErrorLogger errorLogger) {
        super(locale, dbSystem, logger, errorLogger);
    }

    @Override
    protected boolean checkServerShuttingDownStatus() {
        try {
            return this.performCheck();
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError e) {
            this.logger.debug("Server shutdown check failed, using JVM ShutdownHook instead. Error: " + e.toString());
            return false;
        }
    }

    private boolean performCheck() {
        Class<?> minecraftServerClass = Reflection.getMinecraftClass("MinecraftServer");
        Object minecraftServer = Reflection.getField(minecraftServerClass, "SERVER", minecraftServerClass).get(null);
        return Reflection.getField(minecraftServerClass, "isStopped", Boolean.TYPE).get(minecraftServer);
    }
}

