/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.plugin.Plugin;
import com.djrapitops.plan.PlanNukkit;
import com.djrapitops.plan.TaskSystem;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.ExtensionServerMethodCallerTask;
import com.djrapitops.plan.gathering.ShutdownHook;
import com.djrapitops.plan.gathering.timed.NukkitPingCounter;
import com.djrapitops.plan.gathering.timed.ServerTPSCounter;
import com.djrapitops.plan.gathering.timed.SystemUsageBuffer;
import com.djrapitops.plan.gathering.timed.TPSCounter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.upkeep.ConfigStoreTask;
import com.djrapitops.plan.storage.upkeep.DBCleanTask;
import com.djrapitops.plan.storage.upkeep.LogsFolderCleanTask;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.task.RunnableFactory;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NukkitTaskSystem
extends TaskSystem {
    private final PlanNukkit plugin;
    private final PlanConfig config;
    private final ShutdownHook shutdownHook;
    private final JSONCache.CleanTask jsonCacheCleanTask;
    private final LogsFolderCleanTask logsFolderCleanTask;
    private final TPSCounter tpsCounter;
    private final NukkitPingCounter pingCounter;
    private final ConfigStoreTask configStoreTask;
    private final DBCleanTask dbCleanTask;
    private final SystemUsageBuffer.RamAndCpuTask ramAndCpuTask;
    private final SystemUsageBuffer.DiskTask diskTask;
    private final ExtensionServerMethodCallerTask extensionServerMethodCallerTask;

    @Inject
    public NukkitTaskSystem(PlanNukkit plugin, PlanConfig config, ShutdownHook shutdownHook, RunnableFactory runnableFactory, ServerTPSCounter<Level> tpsCounter, NukkitPingCounter pingCounter, ExtensionServerMethodCallerTask extensionServerMethodCallerTask, LogsFolderCleanTask logsFolderCleanTask, ConfigStoreTask configStoreTask, DBCleanTask dbCleanTask, JSONCache.CleanTask jsonCacheCleanTask, SystemUsageBuffer.RamAndCpuTask ramAndCpuTask, SystemUsageBuffer.DiskTask diskTask) {
        super(runnableFactory);
        this.plugin = plugin;
        this.config = config;
        this.shutdownHook = shutdownHook;
        this.jsonCacheCleanTask = jsonCacheCleanTask;
        this.tpsCounter = tpsCounter;
        this.pingCounter = pingCounter;
        this.extensionServerMethodCallerTask = extensionServerMethodCallerTask;
        this.logsFolderCleanTask = logsFolderCleanTask;
        this.configStoreTask = configStoreTask;
        this.dbCleanTask = dbCleanTask;
        this.ramAndCpuTask = ramAndCpuTask;
        this.diskTask = diskTask;
    }

    @Override
    public void enable() {
        this.registerTPSCounter();
        this.registerPingCounter();
        this.registerExtensionDataGatheringTask();
        this.registerUpkeepTasks();
        this.shutdownHook.register();
    }

    private void registerUpkeepTasks() {
        long storeDelay = TimeAmount.toTicks(this.config.get(TimeSettings.CONFIG_UPDATE_INTERVAL), TimeUnit.MILLISECONDS) + 40L;
        this.registerTask(this.configStoreTask).runTaskLaterAsynchronously(storeDelay);
        this.registerTask(this.logsFolderCleanTask).runTaskLaterAsynchronously(TimeAmount.toTicks(30L, TimeUnit.SECONDS));
        this.registerTask(this.dbCleanTask).runTaskTimerAsynchronously(TimeAmount.toTicks(20L, TimeUnit.SECONDS), TimeAmount.toTicks(this.config.get(TimeSettings.CLEAN_DATABASE_PERIOD), TimeUnit.MILLISECONDS));
        long minute = TimeAmount.toTicks(1L, TimeUnit.MINUTES);
        this.registerTask(this.jsonCacheCleanTask).runTaskTimerAsynchronously(minute, minute);
    }

    private void registerTPSCounter() {
        long halfSecondTicks = TimeAmount.toTicks(500L, TimeUnit.MILLISECONDS);
        long secondTicks = TimeAmount.toTicks(1L, TimeUnit.SECONDS);
        long minuteTicks = TimeAmount.toTicks(1L, TimeUnit.MINUTES);
        this.registerTask(this.tpsCounter).runTaskTimer(minuteTicks, secondTicks);
        this.registerTask(this.ramAndCpuTask).runTaskTimerAsynchronously(minuteTicks - halfSecondTicks, secondTicks);
        this.registerTask(this.diskTask).runTaskTimerAsynchronously(50L * secondTicks, minuteTicks);
    }

    private void registerPingCounter() {
        Long pingDelay = this.config.get(TimeSettings.PING_SERVER_ENABLE_DELAY);
        if (pingDelay < TimeUnit.HOURS.toMillis(1L) && this.config.isTrue(DataGatheringSettings.PING)) {
            this.plugin.registerListener(this.pingCounter);
            long startDelay = TimeAmount.toTicks(pingDelay, TimeUnit.MILLISECONDS);
            this.registerTask(this.pingCounter).runTaskTimer(startDelay, 40L);
        }
    }

    private void registerExtensionDataGatheringTask() {
        long extensionRefreshPeriod = TimeAmount.toTicks(this.config.get(TimeSettings.EXTENSION_DATA_REFRESH_PERIOD), TimeUnit.MILLISECONDS);
        this.registerTask(this.extensionServerMethodCallerTask).runTaskTimerAsynchronously(TimeAmount.toTicks(30L, TimeUnit.SECONDS), extensionRefreshPeriod);
    }

    @Override
    public void disable() {
        super.disable();
        Optional.ofNullable(Server.getInstance().getScheduler()).ifPresent(scheduler -> scheduler.cancelTask((Plugin)this.plugin));
    }
}

