/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.BStatsBungee;
import com.djrapitops.plan.DaggerPlanBungeeComponent;
import com.djrapitops.plan.PlanBungeeComponent;
import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.PlanSystem;
import com.djrapitops.plan.commands.PlanProxyCommand;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.settings.theme.PlanColorScheme;
import com.djrapitops.plugin.BungeePlugin;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.logging.L;
import java.io.InputStream;

public class PlanBungee
extends BungeePlugin
implements PlanPlugin {
    private PlanSystem system;
    private Locale locale;

    @Override
    public void onEnable() {
        PlanBungeeComponent component = DaggerPlanBungeeComponent.builder().plan(this).build();
        try {
            this.system = component.system();
            this.locale = this.system.getLocaleSystem().getLocale();
            this.system.enable();
            new BStatsBungee(this, this.system.getDatabaseSystem().getDatabase()).registerMetrics();
            this.logger.info(this.locale.getString(PluginLang.ENABLED));
        }
        catch (AbstractMethodError e) {
            this.logger.error("Plugin ran into AbstractMethodError - Server restart is required. Likely cause is updating the jar without a restart.");
        }
        catch (EnableException e) {
            this.logger.error("----------------------------------------");
            this.logger.error("Error: " + e.getMessage());
            this.logger.error("----------------------------------------");
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /planbungee reload");
            this.onDisable();
        }
        catch (Exception e) {
            this.errorHandler.log(L.CRITICAL, this.getClass(), e);
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /planbungee reload");
            this.logger.error("This error should be reported at https://github.com/Rsl1122/Plan-PlayerAnalytics/issues");
            this.onDisable();
        }
        PlanProxyCommand command = component.planCommand();
        command.registerCommands();
        this.registerCommand("planbungee", command);
        if (this.system != null) {
            this.system.getProcessing().submitNonCritical(() -> this.system.getListenerSystem().callEnableEvent(this));
        }
    }

    @Override
    public void onDisable() {
        if (this.system != null) {
            this.system.disable();
        }
        this.logger.info(this.locale.getString(PluginLang.DISABLED));
    }

    @Override
    public String getVersion() {
        return super.getDescription().getVersion();
    }

    @Override
    public void onReload() {
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getResourceAsStream(resource);
    }

    @Override
    public ColorScheme getColorScheme() {
        return PlanColorScheme.create(this.system.getConfigSystem().getConfig(), this.logger);
    }

    @Override
    public PlanSystem getSystem() {
        return this.system;
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }
}

