/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.DaggerPlanNukkitComponent;
import com.djrapitops.plan.PlanNukkitComponent;
import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.PlanSystem;
import com.djrapitops.plan.addons.placeholderapi.NukkitPlaceholderRegistrar;
import com.djrapitops.plan.commands.PlanCommand;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.gathering.ServerShutdownSave;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.settings.theme.PlanColorScheme;
import com.djrapitops.plugin.NukkitPlugin;
import com.djrapitops.plugin.benchmarking.Benchmark;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.task.AbsRunnable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlanNukkit
extends NukkitPlugin
implements PlanPlugin {
    private PlanSystem system;
    private Locale locale;
    private ServerShutdownSave serverShutdownSave;

    @Override
    public void onEnable() {
        PlanNukkitComponent component = DaggerPlanNukkitComponent.builder().plan(this).build();
        try {
            this.timings.start("Enable");
            this.system = component.system();
            this.serverShutdownSave = component.serverShutdownSave();
            this.locale = this.system.getLocaleSystem().getLocale();
            this.system.enable();
            this.registerPlaceholderAPI(component.placeholders());
            this.logger.debug("Verbose debug messages are enabled.");
            String benchTime = " (" + this.timings.end("Enable").map(Benchmark::toDurationString).orElse("-") + ")";
            this.logger.info(this.locale.getString(PluginLang.ENABLED) + benchTime);
        }
        catch (AbstractMethodError e) {
            this.logger.error("Plugin ran into AbstractMethodError - Server restart is required. Likely cause is updating the jar without a restart.");
        }
        catch (EnableException e) {
            this.logger.error("----------------------------------------");
            this.logger.error("Error: " + e.getMessage());
            this.logger.error("----------------------------------------");
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /plan reload");
            this.onDisable();
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, this.getClass().getSimpleName() + "-v" + this.getVersion(), e);
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /plan reload");
            this.logger.error("This error should be reported at https://github.com/Rsl1122/Plan-PlayerAnalytics/issues");
            this.onDisable();
        }
        PlanCommand command = component.planCommand();
        command.registerCommands();
        this.registerCommand("plan", command);
        if (this.system != null) {
            this.system.getProcessing().submitNonCritical(() -> this.system.getListenerSystem().callEnableEvent(this));
        }
    }

    @Override
    public ColorScheme getColorScheme() {
        return PlanColorScheme.create(this.system.getConfigSystem().getConfig(), this.logger);
    }

    @Override
    public void onDisable() {
        if (this.serverShutdownSave != null) {
            this.serverShutdownSave.performSave();
        }
        if (this.system != null) {
            this.system.disable();
        }
        this.logger.info(this.locale != null ? this.locale.getString(PluginLang.DISABLED) : PluginLang.DISABLED.getDefault());
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public void onReload() {
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public PlanSystem getSystem() {
        return this.system;
    }

    private void registerPlaceholderAPI(final NukkitPlaceholderRegistrar placeholders) {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.runnableFactory.create("Placeholders Registrar", new AbsRunnable(){

                @Override
                public void run() {
                    try {
                        placeholders.register();
                    }
                    catch (Exception | NoClassDefFoundError | NoSuchMethodError failed) {
                        PlanNukkit.this.logger.warn("Failed to register PlaceholderAPI placeholders: " + failed.toString());
                    }
                }
            }).runTask();
        }
    }
}

