/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.BStatsSponge;
import com.djrapitops.plan.DaggerPlanSpongeComponent;
import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.PlanSpongeComponent;
import com.djrapitops.plan.PlanSystem;
import com.djrapitops.plan.commands.PlanCommand;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.gathering.ServerShutdownSave;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.settings.theme.PlanColorScheme;
import com.djrapitops.plugin.SpongePlugin;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.logging.L;
import com.google.inject.Inject;
import java.io.File;
import java.io.InputStream;
import org.bstats.sponge.Metrics2;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;

@Plugin(id="plan", name="Plan", version="5.1 build 624", description="Player Analytics Plugin by Rsl1122", authors={"Rsl1122"}, dependencies={@Dependency(id="griefprevention", optional=true), @Dependency(id="luckperms", optional=true), @Dependency(id="nucleus", optional=true), @Dependency(id="redprotect", optional=true), @Dependency(id="nuvotifier", optional=true)})
public class PlanSponge
extends SpongePlugin
implements PlanPlugin {
    @Inject
    private Metrics2 metrics;
    @Inject
    private Logger slf4jLogger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private File dataFolder;
    private PlanSystem system;
    private Locale locale;
    private ServerShutdownSave serverShutdownSave;

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.onEnable();
    }

    @Listener
    public void onServerStop(GameStoppingServerEvent event) {
        this.onDisable();
    }

    @Override
    public void onEnable() {
        PlanSpongeComponent component = DaggerPlanSpongeComponent.builder().plan(this).build();
        try {
            this.system = component.system();
            this.serverShutdownSave = component.serverShutdownSave();
            this.locale = this.system.getLocaleSystem().getLocale();
            this.system.enable();
            new BStatsSponge(this.metrics, this.system.getDatabaseSystem().getDatabase()).registerMetrics();
            this.logger.info(this.locale.getString(PluginLang.ENABLED));
        }
        catch (AbstractMethodError e) {
            this.logger.error("Plugin ran into AbstractMethodError - Server restart is required. Likely cause is updating the jar without a restart.");
        }
        catch (EnableException e) {
            this.logger.error("----------------------------------------");
            this.logger.error("Error: " + e.getMessage());
            this.logger.error("----------------------------------------");
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /plan reload");
            this.onDisable();
        }
        catch (Exception e) {
            this.errorHandler.log(L.CRITICAL, this.getClass(), e);
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /plan reload");
            this.logger.error("This error should be reported at https://github.com/Rsl1122/Plan-PlayerAnalytics/issues");
            this.onDisable();
        }
        PlanCommand command = component.planCommand();
        command.registerCommands();
        this.registerCommand("plan", command);
        if (this.system != null) {
            this.system.getProcessing().submitNonCritical(() -> this.system.getListenerSystem().callEnableEvent(this));
        }
    }

    @Override
    public void onDisable() {
        if (this.serverShutdownSave != null) {
            this.serverShutdownSave.performSave();
        }
        if (this.system != null) {
            this.system.disable();
        }
        this.logger.info(this.locale.getString(PluginLang.DISABLED));
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getResourceAsStream("/" + resource);
    }

    @Override
    public ColorScheme getColorScheme() {
        return PlanColorScheme.create(this.system.getConfigSystem().getConfig(), this.logger);
    }

    @Override
    public void onReload() {
    }

    @Override
    public boolean isReloading() {
        return false;
    }

    @Override
    public Logger getLogger() {
        return this.slf4jLogger;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public String getVersion() {
        return this.getClass().getAnnotation(Plugin.class).version();
    }

    @Override
    public PlanSystem getSystem() {
        return this.system;
    }

    public Game getGame() {
        return Sponge.getGame();
    }
}

