/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.TaskSystem;
import com.djrapitops.plan.api.PlanAPI;
import com.djrapitops.plan.delivery.DeliveryUtilities;
import com.djrapitops.plan.delivery.export.ExportSystem;
import com.djrapitops.plan.delivery.web.ResolverSvc;
import com.djrapitops.plan.delivery.web.ResourceSvc;
import com.djrapitops.plan.delivery.webserver.NonProxyWebserverDisableChecker;
import com.djrapitops.plan.delivery.webserver.WebServerSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.extension.ExtensionService;
import com.djrapitops.plan.extension.ExtensionSvc;
import com.djrapitops.plan.gathering.cache.CacheSystem;
import com.djrapitops.plan.gathering.importing.ImportSystem;
import com.djrapitops.plan.gathering.listeners.ListenerSystem;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.query.QuerySvc;
import com.djrapitops.plan.settings.ConfigSystem;
import com.djrapitops.plan.settings.SettingsSvc;
import com.djrapitops.plan.settings.locale.LocaleSystem;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plan.version.VersionChecker;
import com.djrapitops.plugin.benchmarking.Benchmark;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlanSystem
implements SubSystem {
    private boolean enabled = false;
    private final PlanFiles files;
    private final ConfigSystem configSystem;
    private final VersionChecker versionChecker;
    private final LocaleSystem localeSystem;
    private final DBSystem databaseSystem;
    private final CacheSystem cacheSystem;
    private final ListenerSystem listenerSystem;
    private final TaskSystem taskSystem;
    private final ServerInfo serverInfo;
    private final WebServerSystem webServerSystem;
    private final Processing processing;
    private final ImportSystem importSystem;
    private final ExportSystem exportSystem;
    private final DeliveryUtilities deliveryUtilities;
    private final ResolverSvc resolverService;
    private final ResourceSvc resourceService;
    private final ExtensionSvc extensionService;
    private final QuerySvc queryService;
    private final SettingsSvc settingsService;
    private final PluginLogger logger;
    private final Timings timings;
    private final ErrorLogger errorLogger;

    @Inject
    public PlanSystem(PlanFiles files, ConfigSystem configSystem, VersionChecker versionChecker, LocaleSystem localeSystem, DBSystem databaseSystem, CacheSystem cacheSystem, ListenerSystem listenerSystem, TaskSystem taskSystem, ServerInfo serverInfo, WebServerSystem webServerSystem, Processing processing, ImportSystem importSystem, ExportSystem exportSystem, DeliveryUtilities deliveryUtilities, ResolverSvc resolverService, ResourceSvc resourceService, ExtensionSvc extensionService, QuerySvc queryService, SettingsSvc settingsService, PluginLogger logger, Timings timings, ErrorLogger errorLogger, PlanAPI.PlanAPIHolder apiHolder) {
        this.files = files;
        this.configSystem = configSystem;
        this.versionChecker = versionChecker;
        this.localeSystem = localeSystem;
        this.databaseSystem = databaseSystem;
        this.cacheSystem = cacheSystem;
        this.listenerSystem = listenerSystem;
        this.taskSystem = taskSystem;
        this.serverInfo = serverInfo;
        this.webServerSystem = webServerSystem;
        this.processing = processing;
        this.importSystem = importSystem;
        this.exportSystem = exportSystem;
        this.deliveryUtilities = deliveryUtilities;
        this.resolverService = resolverService;
        this.resourceService = resourceService;
        this.extensionService = extensionService;
        this.queryService = queryService;
        this.settingsService = settingsService;
        this.logger = logger;
        this.timings = timings;
        this.errorLogger = errorLogger;
        logger.log(L.INFO_COLOR, "", "\u00a72           \u2588\u2588\u258c", "\u00a72     \u2588\u2588\u258c   \u2588\u2588\u258c", "\u00a72  \u2588\u2588\u258c\u2588\u2588\u258c\u2588\u2588\u258c\u2588\u2588\u258c  \u00a72Player Analytics", "\u00a72  \u2588\u2588\u258c\u2588\u2588\u258c\u2588\u2588\u258c\u2588\u2588\u258c  \u00a7fv" + versionChecker.getCurrentVersion(), "");
    }

    @Deprecated
    public String getMainAddress() {
        return this.webServerSystem.getAddresses().getMainAddress().orElse(this.webServerSystem.getAddresses().getFallbackLocalhostAddress());
    }

    @Override
    public void enable() throws EnableException {
        this.extensionService.register();
        this.resolverService.register();
        this.resourceService.register();
        this.settingsService.register();
        this.queryService.register();
        this.enableSystems(this.files, this.configSystem, this.localeSystem, this.versionChecker, this.databaseSystem, this.webServerSystem, this.processing, this.serverInfo, this.importSystem, this.exportSystem, this.cacheSystem, this.listenerSystem, this.taskSystem);
        if (this.serverInfo.getServer().isNotProxy()) {
            this.processing.submitNonCritical(new NonProxyWebserverDisableChecker(this.configSystem.getConfig(), this.webServerSystem.getAddresses(), this.webServerSystem, this.logger, this.errorLogger));
        }
        this.extensionService.registerExtensions();
        this.enabled = true;
    }

    private void enableSystems(SubSystem ... systems) throws EnableException {
        for (SubSystem system : systems) {
            this.logger.debug("Enabling: " + system.getClass().getSimpleName());
            this.timings.start("subsystem-enable");
            system.enable();
            this.timings.end("subsystem-enable").map(Benchmark::toDurationString).map(duration -> "Took " + duration).ifPresent(xva$0 -> this.logger.debug((String)xva$0));
        }
    }

    @Override
    public void disable() {
        this.enabled = false;
        this.disableSystems(this.taskSystem, this.cacheSystem, this.listenerSystem, this.importSystem, this.exportSystem, this.processing, this.databaseSystem, this.webServerSystem, this.serverInfo, this.localeSystem, this.configSystem, this.files, this.versionChecker);
    }

    private void disableSystems(SubSystem ... systems) {
        for (SubSystem system : systems) {
            try {
                if (system == null) continue;
                system.disable();
            }
            catch (Exception e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)("Disabling PlanSystem: " + system)).build());
            }
        }
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public ConfigSystem getConfigSystem() {
        return this.configSystem;
    }

    public PlanFiles getPlanFiles() {
        return this.files;
    }

    public DBSystem getDatabaseSystem() {
        return this.databaseSystem;
    }

    public ListenerSystem getListenerSystem() {
        return this.listenerSystem;
    }

    public TaskSystem getTaskSystem() {
        return this.taskSystem;
    }

    public WebServerSystem getWebServerSystem() {
        return this.webServerSystem;
    }

    public ImportSystem getImportSystem() {
        return this.importSystem;
    }

    public ExportSystem getExportSystem() {
        return this.exportSystem;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public CacheSystem getCacheSystem() {
        return this.cacheSystem;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public LocaleSystem getLocaleSystem() {
        return this.localeSystem;
    }

    public DeliveryUtilities getDeliveryUtilities() {
        return this.deliveryUtilities;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ExtensionService getExtensionService() {
        return this.extensionService;
    }

    public ErrorLogger getErrorLogger() {
        return this.errorLogger;
    }
}

