/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.DaggerPlanVelocityComponent;
import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.PlanSystem;
import com.djrapitops.plan.PlanVelocityComponent;
import com.djrapitops.plan.commands.PlanProxyCommand;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.settings.theme.PlanColorScheme;
import com.djrapitops.plugin.VelocityPlugin;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.logging.L;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.InputStream;
import java.nio.file.Path;
import org.slf4j.Logger;

@Plugin(id="plan", name="Plan", version="5.1 build 624", description="Player Analytics Plugin by Rsl1122", authors={"Rsl1122"})
public class PlanVelocity
extends VelocityPlugin
implements PlanPlugin {
    private PlanSystem system;
    private Locale locale;

    @Inject
    public PlanVelocity(ProxyServer proxy, Logger slf4jLogger, @DataDirectory Path dataFolderPath) {
        super(proxy, slf4jLogger, dataFolderPath);
    }

    @Subscribe
    public void onProxyStart(ProxyInitializeEvent event) {
        this.onEnable();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.onDisable();
    }

    @Override
    public void onEnable() {
        PlanVelocityComponent component = DaggerPlanVelocityComponent.builder().plan(this).build();
        try {
            this.system = component.system();
            this.locale = this.system.getLocaleSystem().getLocale();
            this.system.enable();
            this.logger.info(this.locale.getString(PluginLang.ENABLED));
        }
        catch (AbstractMethodError e) {
            this.logger.error("Plugin ran into AbstractMethodError - Server restart is required. Likely cause is updating the jar without a restart.");
        }
        catch (EnableException e) {
            this.logger.error("----------------------------------------");
            this.logger.error("Error: " + e.getMessage());
            this.logger.error("----------------------------------------");
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /planvelocity reload");
            this.onDisable();
        }
        catch (Exception e) {
            this.errorHandler.log(L.CRITICAL, this.getClass(), e);
            this.logger.error("Plugin Failed to Initialize Correctly. If this issue is caused by config settings you can use /planvelocity reload");
            this.logger.error("This error should be reported at https://github.com/Rsl1122/Plan-PlayerAnalytics/issues");
            this.onDisable();
        }
        PlanProxyCommand command = component.planCommand();
        command.registerCommands();
        this.registerCommand("planvelocity", command);
        if (this.system != null) {
            this.system.getProcessing().submitNonCritical(() -> this.system.getListenerSystem().callEnableEvent(this));
        }
    }

    @Override
    public void onDisable() {
        this.system.disable();
        this.logger.info(this.locale.getString(PluginLang.DISABLED));
    }

    @Override
    public void onReload() {
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getResourceAsStream("/" + resource);
    }

    @Override
    public ColorScheme getColorScheme() {
        return PlanColorScheme.create(this.system.getConfigSystem().getConfig(), this.logger);
    }

    @Override
    public PlanSystem getSystem() {
        return this.system;
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }
}

