/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.gathering.ServerShutdownSave;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import org.spongepowered.api.GameState;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SpongeServerShutdownSave
extends ServerShutdownSave {
    private boolean shuttingDown = false;

    @Inject
    public SpongeServerShutdownSave(Locale locale, DBSystem dbSystem, PluginLogger logger, ErrorLogger errorLogger) {
        super(locale, dbSystem, logger, errorLogger);
    }

    @Override
    protected boolean checkServerShuttingDownStatus() {
        return this.shuttingDown;
    }

    @Listener(order=Order.PRE)
    public void onServerShutdown(GameStoppingServerEvent event) {
        GameState state = event.getState();
        this.shuttingDown = state == GameState.SERVER_STOPPING || state == GameState.GAME_STOPPING || state == GameState.SERVER_STOPPED || state == GameState.GAME_STOPPED;
    }
}

