/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan;

import com.djrapitops.plan.PlanVelocity;
import com.djrapitops.plan.TaskSystem;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.ExtensionServerMethodCallerTask;
import com.djrapitops.plan.gathering.timed.ProxyTPSCounter;
import com.djrapitops.plan.gathering.timed.SystemUsageBuffer;
import com.djrapitops.plan.gathering.timed.TPSCounter;
import com.djrapitops.plan.gathering.timed.VelocityPingCounter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.upkeep.NetworkConfigStoreTask;
import com.djrapitops.plan.storage.upkeep.DBCleanTask;
import com.djrapitops.plan.storage.upkeep.LogsFolderCleanTask;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.task.RunnableFactory;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class VelocityTaskSystem
extends TaskSystem {
    private final PlanVelocity plugin;
    private final PlanConfig config;
    private final TPSCounter tpsCounter;
    private final VelocityPingCounter pingCounter;
    private final LogsFolderCleanTask logsFolderCleanTask;
    private final NetworkConfigStoreTask networkConfigStoreTask;
    private final DBCleanTask dbCleanTask;
    private final JSONCache.CleanTask jsonCacheCleanTask;
    private final ExtensionServerMethodCallerTask extensionServerMethodCallerTask;
    private final SystemUsageBuffer.RamAndCpuTask ramAndCpuTask;
    private final SystemUsageBuffer.DiskTask diskTask;

    @Inject
    public VelocityTaskSystem(PlanVelocity plugin, PlanConfig config, RunnableFactory runnableFactory, ProxyTPSCounter tpsCounter, VelocityPingCounter pingCounter, LogsFolderCleanTask logsFolderCleanTask, NetworkConfigStoreTask networkConfigStoreTask, DBCleanTask dbCleanTask, JSONCache.CleanTask jsonCacheCleanTask, ExtensionServerMethodCallerTask extensionServerMethodCallerTask, SystemUsageBuffer.RamAndCpuTask ramAndCpuTask, SystemUsageBuffer.DiskTask diskTask) {
        super(runnableFactory);
        this.plugin = plugin;
        this.config = config;
        this.tpsCounter = tpsCounter;
        this.pingCounter = pingCounter;
        this.logsFolderCleanTask = logsFolderCleanTask;
        this.networkConfigStoreTask = networkConfigStoreTask;
        this.dbCleanTask = dbCleanTask;
        this.jsonCacheCleanTask = jsonCacheCleanTask;
        this.extensionServerMethodCallerTask = extensionServerMethodCallerTask;
        this.ramAndCpuTask = ramAndCpuTask;
        this.diskTask = diskTask;
    }

    @Override
    public void enable() {
        this.registerTasks();
    }

    private void registerTPSCounter() {
        long halfSecondTicks = TimeAmount.toTicks(500L, TimeUnit.MILLISECONDS);
        long secondTicks = TimeAmount.toTicks(1L, TimeUnit.SECONDS);
        long minuteTicks = TimeAmount.toTicks(1L, TimeUnit.MINUTES);
        this.registerTask(this.tpsCounter).runTaskTimer(minuteTicks, secondTicks);
        this.registerTask(this.ramAndCpuTask).runTaskTimerAsynchronously(minuteTicks - halfSecondTicks, secondTicks);
        this.registerTask(this.diskTask).runTaskTimerAsynchronously(50L * secondTicks, minuteTicks);
    }

    private void registerTasks() {
        this.registerTPSCounter();
        this.registerTask(this.logsFolderCleanTask).runTaskLaterAsynchronously(TimeAmount.toTicks(30L, TimeUnit.SECONDS));
        Long pingDelay = this.config.get(TimeSettings.PING_SERVER_ENABLE_DELAY);
        if (pingDelay < TimeUnit.HOURS.toMillis(1L) && this.config.isTrue(DataGatheringSettings.PING)) {
            this.plugin.registerListener(this.pingCounter);
            long startDelay = TimeAmount.toTicks(pingDelay, TimeUnit.MILLISECONDS);
            this.registerTask(this.pingCounter).runTaskTimer(startDelay, 40L);
        }
        long storeDelay = TimeAmount.toTicks(this.config.get(TimeSettings.CONFIG_UPDATE_INTERVAL), TimeUnit.MILLISECONDS) + 40L;
        this.registerTask(this.networkConfigStoreTask).runTaskLaterAsynchronously(storeDelay);
        this.registerTask(this.dbCleanTask).runTaskTimerAsynchronously(TimeAmount.toTicks(20L, TimeUnit.SECONDS), TimeAmount.toTicks(this.config.get(TimeSettings.CLEAN_DATABASE_PERIOD), TimeUnit.MILLISECONDS));
        long minute = TimeAmount.toTicks(1L, TimeUnit.MINUTES);
        this.registerTask(this.jsonCacheCleanTask).runTaskTimerAsynchronously(minute, minute);
        long extensionRefreshPeriod = TimeAmount.toTicks(this.config.get(TimeSettings.EXTENSION_DATA_REFRESH_PERIOD), TimeUnit.MILLISECONDS);
        this.registerTask(this.extensionServerMethodCallerTask).runTaskTimerAsynchronously(TimeAmount.toTicks(30L, TimeUnit.SECONDS), extensionRefreshPeriod);
    }
}

