/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.addons.placeholderapi;

import cn.nukkit.Player;
import com.creeperface.nukkit.placeholderapi.api.PlaceholderAPI;
import com.djrapitops.plan.PlanSystem;
import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.placeholder.PlanPlaceholders;
import com.djrapitops.plan.storage.database.queries.containers.ContainerFetchQueries;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NukkitPlaceholderRegistrar {
    private final PlanPlaceholders placeholders;
    private final PlanSystem system;
    private final ErrorLogger errorLogger;

    @Inject
    public NukkitPlaceholderRegistrar(PlanPlaceholders placeholders, PlanSystem system, ErrorLogger errorLogger) {
        this.placeholders = placeholders;
        this.system = system;
        this.errorLogger = errorLogger;
    }

    public void register() {
        PlaceholderAPI api = PlaceholderAPI.getInstance();
        this.placeholders.getPlaceholders().forEach((name, loader) -> api.visitorSensitivePlaceholder(name, (player, params) -> {
            try {
                return (Serializable)loader.apply(this.getPlayer((Player)player), params.get());
            }
            catch (Exception e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)"Registering PlaceholderAPI").build());
                return null;
            }
        }, new String[0]));
        this.placeholders.getStaticPlaceholders().forEach((name, loader) -> api.staticPlaceholder(name, params -> {
            try {
                return (Serializable)loader.apply(params.get());
            }
            catch (Exception e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)"Registering PlaceholderAPI").build());
                return null;
            }
        }, new String[0]));
    }

    private PlayerContainer getPlayer(Player player) {
        UUID uuid = player.getUniqueId();
        PlayerContainer container = this.system.getDatabaseSystem().getDatabase().query(ContainerFetchQueries.fetchPlayerContainer(uuid));
        SessionCache.getCachedSession(uuid).ifPresent(session -> container.putRawData(PlayerKeys.ACTIVE_SESSION, session));
        return container;
    }
}

