/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.addons.placeholderapi;

import com.djrapitops.plan.PlanSystem;
import com.djrapitops.plan.placeholder.PlanPlaceholders;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plan.version.VersionChecker;
import com.djrapitops.plugin.logging.L;
import java.util.Collections;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class PlanPlaceholderExtension
extends PlaceholderExpansion {
    private final ErrorLogger errorLogger;
    private final VersionChecker versionChecker;
    private final PlanPlaceholders placeholders;

    public PlanPlaceholderExtension(PlanPlaceholders placeholders, PlanSystem system, ErrorLogger errorLogger) {
        this.placeholders = placeholders;
        this.versionChecker = system.getVersionChecker();
        this.errorLogger = errorLogger;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getIdentifier() {
        return "plan";
    }

    public String getPlugin() {
        return "Plan";
    }

    public String getAuthor() {
        return "Rsl1122";
    }

    public String getVersion() {
        return this.versionChecker.getCurrentVersion();
    }

    public String onPlaceholderRequest(Player player, String params) {
        UUID uuid = player != null ? player.getUniqueId() : null;
        try {
            String value = this.placeholders.onPlaceholderRequest(uuid, params, Collections.emptyList());
            if ("true".equals(value)) {
                value = PlaceholderAPIPlugin.booleanTrue();
            } else if ("false".equals(value)) {
                value = PlaceholderAPIPlugin.booleanFalse();
            }
            return value;
        }
        catch (Exception e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("Report this").related("Placeholder Request", params, uuid).build());
            return null;
        }
    }
}

