/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.api;

import com.djrapitops.plan.api.PlanAPI;
import com.djrapitops.plan.api.data.PlayerContainer;
import com.djrapitops.plan.api.data.ServerContainer;
import com.djrapitops.plan.data.plugin.PluginData;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.containers.ContainerFetchQueries;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
@Deprecated
public class CommonAPI
implements PlanAPI {
    private final DBSystem dbSystem;
    private final UUIDUtility uuidUtility;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;

    @Inject
    public CommonAPI(DBSystem dbSystem, UUIDUtility uuidUtility, PluginLogger logger, ErrorLogger errorLogger) {
        this.dbSystem = dbSystem;
        this.uuidUtility = uuidUtility;
        this.logger = logger;
        this.errorLogger = errorLogger;
        PlanAPI.PlanAPIHolder.set(this);
    }

    @Override
    public void addPluginDataSource(PluginData pluginData) {
        this.logger.warn(pluginData.getClass().getName() + " was attempted to be registered. PluginData API has been decommissioned, so this is a no-op. Please move to using DataExtension API. https://github.com/plan-player-analytics/Plan/wiki/APIv5");
    }

    @Override
    public String getPlayerInspectPageLink(UUID uuid) {
        return this.getPlayerInspectPageLink(this.getPlayerName(uuid));
    }

    @Override
    public String getPlayerInspectPageLink(String playerName) {
        return "../player/" + Html.encodeToURL(playerName);
    }

    @Override
    public UUID playerNameToUUID(String playerName) {
        return this.uuidUtility.getUUIDOf(playerName);
    }

    @Override
    public Map<UUID, String> getKnownPlayerNames() {
        try {
            return this.queryDB(UserIdentifierQueries.fetchAllPlayerNames());
        }
        catch (DBOpException e) {
            this.errorLogger.log(L.ERROR, this.getClass(), e);
            return new HashMap<UUID, String>();
        }
    }

    @Override
    public PlayerContainer fetchPlayerContainer(UUID uuid) {
        return new PlayerContainer(this.queryDB(ContainerFetchQueries.fetchPlayerContainer(uuid)));
    }

    @Override
    public ServerContainer fetchServerContainer(UUID serverUUID) {
        return new ServerContainer(this.queryDB(ContainerFetchQueries.fetchServerContainer(serverUUID)));
    }

    @Override
    public Collection<UUID> fetchServerUUIDs() {
        return this.queryDB(ServerQueries.fetchPlanServerInformation()).keySet();
    }

    @Override
    public String getPlayerName(UUID playerUUID) {
        return this.queryDB(UserIdentifierQueries.fetchPlayerNameOf(playerUUID)).orElse(null);
    }

    private <T> T queryDB(Query<T> query) {
        return this.dbSystem.getDatabase().query(query);
    }
}

