/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Arguments {
    private final List<String> args;

    public Arguments(String[] args) {
        this.args = Arrays.asList(args);
    }

    public Arguments(List<String> args) {
        this.args = args;
    }

    public Optional<String> get(int index) {
        return index < this.args.size() ? Optional.of(this.args.get(index)) : Optional.empty();
    }

    public Optional<Integer> getInteger(int index) {
        return this.get(index).map(Integer::parseInt);
    }

    public Optional<String> getAfter(String argumentIdentifier) {
        for (int i = 0; i < this.args.size(); ++i) {
            String argument = this.args.get(i);
            if (!argumentIdentifier.equals(argument)) continue;
            return this.get(i + 1);
        }
        return Optional.empty();
    }

    public boolean contains(String argument) {
        return this.args.contains(argument);
    }

    public List<String> asList() {
        return this.args;
    }
}

