/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands;

import com.djrapitops.plan.commands.subcommands.AnalyzeCommand;
import com.djrapitops.plan.commands.subcommands.DevCommand;
import com.djrapitops.plan.commands.subcommands.InfoCommand;
import com.djrapitops.plan.commands.subcommands.InspectCommand;
import com.djrapitops.plan.commands.subcommands.ListPlayersCommand;
import com.djrapitops.plan.commands.subcommands.ListServersCommand;
import com.djrapitops.plan.commands.subcommands.ManageCommand;
import com.djrapitops.plan.commands.subcommands.NetworkCommand;
import com.djrapitops.plan.commands.subcommands.QInspectCommand;
import com.djrapitops.plan.commands.subcommands.RegisterCommand;
import com.djrapitops.plan.commands.subcommands.ReloadCommand;
import com.djrapitops.plan.commands.subcommands.SearchCommand;
import com.djrapitops.plan.commands.subcommands.UnregisterCommand;
import com.djrapitops.plan.commands.subcommands.WebUserCommand;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.TreeCmdNode;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlanCommand
extends TreeCmdNode {
    private final PlanConfig config;
    private final InspectCommand inspectCommand;
    private final QInspectCommand qInspectCommand;
    private final SearchCommand searchCommand;
    private final ListPlayersCommand listPlayersCommand;
    private final AnalyzeCommand analyzeCommand;
    private final NetworkCommand networkCommand;
    private final ListServersCommand listServersCommand;
    private final Lazy<WebUserCommand> webUserCommand;
    private final RegisterCommand registerCommand;
    private final UnregisterCommand unregisterCommand;
    private final InfoCommand infoCommand;
    private final ReloadCommand reloadCommand;
    private final Lazy<ManageCommand> manageCommand;
    private final DevCommand devCommand;
    private boolean commandsRegistered;

    @Inject
    public PlanCommand(ColorScheme colorScheme, Locale locale, PlanConfig config, InspectCommand inspectCommand, QInspectCommand qInspectCommand, SearchCommand searchCommand, ListPlayersCommand listPlayersCommand, AnalyzeCommand analyzeCommand, NetworkCommand networkCommand, ListServersCommand listServersCommand, Lazy<WebUserCommand> webUserCommand, RegisterCommand registerCommand, UnregisterCommand unregisterCommand, InfoCommand infoCommand, ReloadCommand reloadCommand, Lazy<ManageCommand> manageCommand, DevCommand devCommand) {
        super("plan", "", CommandType.CONSOLE, null);
        this.unregisterCommand = unregisterCommand;
        this.commandsRegistered = false;
        this.config = config;
        this.inspectCommand = inspectCommand;
        this.qInspectCommand = qInspectCommand;
        this.searchCommand = searchCommand;
        this.listPlayersCommand = listPlayersCommand;
        this.analyzeCommand = analyzeCommand;
        this.networkCommand = networkCommand;
        this.listServersCommand = listServersCommand;
        this.webUserCommand = webUserCommand;
        this.registerCommand = registerCommand;
        this.infoCommand = infoCommand;
        this.reloadCommand = reloadCommand;
        this.manageCommand = manageCommand;
        this.devCommand = devCommand;
        this.getHelpCommand().setPermission(Permissions.HELP.getPermission());
        this.setDefaultCommand("inspect");
        this.setColorScheme(colorScheme);
        this.setInDepthHelp(locale.getArray(DeepHelpLang.PLAN));
    }

    public void registerCommands() {
        if (this.commandsRegistered) {
            return;
        }
        CommandNode[] analyticsGroup = new CommandNode[]{this.inspectCommand, this.qInspectCommand, this.searchCommand, this.listPlayersCommand, this.analyzeCommand, this.networkCommand, this.listServersCommand};
        CommandNode[] webGroup = new CommandNode[]{this.webUserCommand.get(), this.registerCommand, this.unregisterCommand};
        CommandNode[] manageGroup = new CommandNode[]{this.infoCommand, this.reloadCommand, this.manageCommand.get(), this.config.isTrue(PluginSettings.DEV_MODE) ? this.devCommand : null};
        this.setNodeGroups(analyticsGroup, webGroup, manageGroup);
        this.commandsRegistered = true;
    }
}

