/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands;

import com.djrapitops.plan.commands.subcommands.DisableCommand;
import com.djrapitops.plan.commands.subcommands.ListPlayersCommand;
import com.djrapitops.plan.commands.subcommands.ListServersCommand;
import com.djrapitops.plan.commands.subcommands.NetworkCommand;
import com.djrapitops.plan.commands.subcommands.RegisterCommand;
import com.djrapitops.plan.commands.subcommands.ReloadCommand;
import com.djrapitops.plan.commands.subcommands.UnregisterCommand;
import com.djrapitops.plan.commands.subcommands.WebUserCommand;
import com.djrapitops.plan.commands.subcommands.manage.ManageRawDataCommand;
import com.djrapitops.plan.commands.subcommands.manage.ManageUninstalledCommand;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.TreeCmdNode;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Named;
import plan.javax.inject.Singleton;

@Singleton
public class PlanProxyCommand
extends TreeCmdNode {
    private final NetworkCommand networkCommand;
    private final ListServersCommand listServersCommand;
    private final ListPlayersCommand listPlayersCommand;
    private final RegisterCommand registerCommand;
    private final UnregisterCommand unregisterCommand;
    private final Lazy<WebUserCommand> webUserCommand;
    private final ManageRawDataCommand rawDataCommand;
    private final ReloadCommand reloadCommand;
    private final DisableCommand disableCommand;
    private final ManageUninstalledCommand uninstalledCommand;
    private boolean commandsRegistered;

    @Inject
    public PlanProxyCommand(@Named(value="mainCommandName") String mainCommandName, ColorScheme colorScheme, Locale locale, NetworkCommand networkCommand, ListServersCommand listServersCommand, ListPlayersCommand listPlayersCommand, RegisterCommand registerCommand, UnregisterCommand unregisterCommand, Lazy<WebUserCommand> webUserCommand, ManageRawDataCommand rawDataCommand, ManageUninstalledCommand uninstalledCommand, ReloadCommand reloadCommand, DisableCommand disableCommand) {
        super(mainCommandName, Permissions.MANAGE.getPermission(), CommandType.CONSOLE, null);
        this.unregisterCommand = unregisterCommand;
        this.uninstalledCommand = uninstalledCommand;
        this.commandsRegistered = false;
        this.networkCommand = networkCommand;
        this.listServersCommand = listServersCommand;
        this.listPlayersCommand = listPlayersCommand;
        this.registerCommand = registerCommand;
        this.webUserCommand = webUserCommand;
        this.rawDataCommand = rawDataCommand;
        this.reloadCommand = reloadCommand;
        this.disableCommand = disableCommand;
        this.getHelpCommand().setPermission(Permissions.MANAGE.getPermission());
        this.setColorScheme(colorScheme);
        this.setInDepthHelp(locale.getArray(DeepHelpLang.PLAN));
    }

    public void registerCommands() {
        if (this.commandsRegistered) {
            return;
        }
        CommandNode[] analyticsGroup = new CommandNode[]{this.networkCommand, this.listServersCommand, this.listPlayersCommand};
        CommandNode[] webGroup = new CommandNode[]{this.registerCommand, this.unregisterCommand, this.webUserCommand.get()};
        CommandNode[] manageGroup = new CommandNode[]{this.rawDataCommand, this.uninstalledCommand, this.reloadCommand, this.disableCommand};
        this.setNodeGroups(analyticsGroup, webGroup, manageGroup);
        this.commandsRegistered = true;
    }
}

