/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.exceptions.ExportException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class AnalyzeCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final Exporter exporter;
    private final Addresses addresses;
    private final ServerInfo serverInfo;
    private final WebServer webServer;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public AnalyzeCommand(Locale locale, Processing processing, Exporter exporter, Addresses addresses, ServerInfo serverInfo, WebServer webServer, DBSystem dbSystem, ErrorLogger errorLogger) {
        super("analyze|analyse|analysis|a", Permissions.ANALYZE.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.processing = processing;
        this.exporter = exporter;
        this.addresses = addresses;
        this.serverInfo = serverInfo;
        this.webServer = webServer;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.ANALYZE));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.ANALYZE));
        this.setArguments("[server/id]");
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Database database = this.dbSystem.getDatabase();
        Database.State dbState = database.getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        this.processing.submitNonCritical(() -> {
            try {
                Server server = this.getServer(args);
                this.sendWebUserNotificationIfNecessary(sender);
                this.exporter.exportServerPage(server);
                this.sendLink(server, sender);
            }
            catch (ExportException | DBOpException e) {
                sender.sendMessage("\u00a7cError occurred: " + e.toString());
                this.errorLogger.log(L.ERROR, this.getClass(), e);
            }
        });
    }

    private void sendLink(Server server, Sender sender) {
        boolean console;
        String target = "/server/" + Html.encodeToURL(server.getName());
        String address = this.addresses.getMainAddress().orElseGet(() -> {
            sender.sendMessage(this.locale.getString(CommandLang.NO_ADDRESS_NOTIFY));
            return this.addresses.getFallbackLocalhostAddress();
        });
        String url = address + target;
        String linkPrefix = this.locale.getString(CommandLang.LINK_PREFIX);
        sender.sendMessage(this.locale.getString(CommandLang.HEADER_ANALYSIS));
        boolean bl = console = !CommandUtils.isPlayer(sender);
        if (console) {
            sender.sendMessage(linkPrefix + url);
        } else {
            sender.sendMessage(linkPrefix);
            sender.sendLink("   ", this.locale.getString(CommandLang.LINK_CLICK_ME), url);
        }
        sender.sendMessage(">");
    }

    private void sendWebUserNotificationIfNecessary(Sender sender) {
        if (this.webServer.isAuthRequired() && CommandUtils.isPlayer(sender) && !this.dbSystem.getDatabase().query(WebUserQueries.fetchUserLinkedTo(sender.getName())).isPresent()) {
            sender.sendMessage("\u00a7e" + this.locale.getString(CommandLang.NO_WEB_USER_NOTIFY));
        }
    }

    private Server getServer(String[] args) {
        return this.getGivenIdentifier(args).flatMap(serverIdentifier -> this.dbSystem.getDatabase().query(ServerQueries.fetchServerMatchingIdentifier(serverIdentifier))).filter(server -> !server.isProxy()).orElseGet(this.serverInfo::getServer);
    }

    private Optional<String> getGivenIdentifier(String[] args) {
        if (args.length < 1) {
            return Optional.empty();
        }
        StringBuilder idBuilder = new StringBuilder(args[0]);
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                idBuilder.append(" ").append(args[i]);
            }
        }
        return Optional.of(idBuilder.toString());
    }
}

