/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.version.VersionChecker;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import java.io.Serializable;
import plan.javax.inject.Inject;

public class InfoCommand
extends CommandNode {
    private final PlanPlugin plugin;
    private final Locale locale;
    private final DBSystem dbSystem;
    private final VersionChecker versionChecker;

    @Inject
    public InfoCommand(PlanPlugin plugin, Locale locale, DBSystem dbSystem, VersionChecker versionChecker) {
        super("info", Permissions.INFO.getPermission(), CommandType.CONSOLE);
        this.plugin = plugin;
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.versionChecker = versionChecker;
        this.setShortHelp(locale.get(CmdHelpLang.INFO).toString());
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        String yes = this.locale.getString(GenericLang.YES);
        String no = this.locale.getString(GenericLang.NO);
        Database database = this.dbSystem.getDatabase();
        String updateAvailable = this.versionChecker.isNewVersionAvailable() ? yes : no;
        String proxyAvailable = database.query(ServerQueries.fetchProxyServerInformation()).isPresent() ? yes : no;
        String[] messages = new String[]{this.locale.getString(CommandLang.HEADER_INFO), "", this.locale.getString(CommandLang.INFO_VERSION, new Serializable[]{this.plugin.getVersion()}), this.locale.getString(CommandLang.INFO_UPDATE, new Serializable[]{updateAvailable}), this.locale.getString(CommandLang.INFO_DATABASE, new Serializable[]{database.getType().getName() + " (" + database.getState().name() + ")"}), this.locale.getString(CommandLang.INFO_PROXY_CONNECTION, new Serializable[]{proxyAvailable}), "", ">"};
        sender.sendMessage(messages);
    }
}

