/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.UUID;
import plan.javax.inject.Inject;

public class InspectCommand
extends CommandNode {
    private final Locale locale;
    private final DBSystem dbSystem;
    private final WebServer webServer;
    private final Addresses addresses;
    private final Processing processing;
    private final UUIDUtility uuidUtility;
    private final ErrorLogger errorLogger;

    @Inject
    public InspectCommand(Locale locale, Addresses addresses, Processing processing, DBSystem dbSystem, WebServer webServer, UUIDUtility uuidUtility, ErrorLogger errorLogger) {
        super("inspect", Permissions.INSPECT.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.addresses = addresses;
        this.processing = processing;
        this.setArguments("<player>");
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.webServer = webServer;
        this.uuidUtility = uuidUtility;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.INSPECT));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.INSPECT));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        String playerName = MiscUtils.getPlayerName(args, sender);
        if (playerName == null) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_NO_PERMISSION));
            return;
        }
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        this.runInspectTask(playerName, sender);
    }

    private void runInspectTask(String playerName, Sender sender) {
        this.processing.submitNonCritical(() -> {
            try {
                UUID playerUUID = this.uuidUtility.getUUIDOf(playerName);
                if (playerUUID == null) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_USERNAME_NOT_VALID));
                    return;
                }
                if (!this.dbSystem.getDatabase().query(PlayerFetchQueries.isPlayerRegistered(playerUUID)).booleanValue()) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_USERNAME_NOT_KNOWN));
                    return;
                }
                this.checkWebUserAndNotify(sender);
                this.sendInspectMsg(sender, playerName);
            }
            catch (DBOpException e) {
                sender.sendMessage("\u00a7eDatabase exception occurred: " + e.getMessage());
                this.errorLogger.log(L.ERROR, this.getClass(), e);
            }
        });
    }

    private void checkWebUserAndNotify(Sender sender) {
        boolean senderHasWebUser;
        if (CommandUtils.isPlayer(sender) && this.webServer.isAuthRequired() && !(senderHasWebUser = this.dbSystem.getDatabase().query(WebUserQueries.fetchUserLinkedTo(sender.getName())).isPresent())) {
            sender.sendMessage("\u00a7e" + this.locale.getString(CommandLang.NO_WEB_USER_NOTIFY));
        }
    }

    private void sendInspectMsg(Sender sender, String playerName) {
        boolean console;
        sender.sendMessage(this.locale.getString(CommandLang.HEADER_INSPECT, new Serializable[]{playerName}));
        String address = this.addresses.getMainAddress().orElseGet(() -> {
            sender.sendMessage(this.locale.getString(CommandLang.NO_ADDRESS_NOTIFY));
            return this.addresses.getFallbackLocalhostAddress();
        });
        String url = address + "/player/" + Html.encodeToURL(playerName);
        String linkPrefix = this.locale.getString(CommandLang.LINK_PREFIX);
        boolean bl = console = !CommandUtils.isPlayer(sender);
        if (console) {
            sender.sendMessage(linkPrefix + url);
        } else {
            sender.sendMessage(linkPrefix);
            sender.sendLink("   ", this.locale.getString(CommandLang.LINK_CLICK_ME), url);
        }
        sender.sendMessage(">");
    }
}

