/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import plan.javax.inject.Inject;

public class ListPlayersCommand
extends CommandNode {
    private final Locale locale;
    private final Addresses addresses;
    private final Processing processing;

    @Inject
    public ListPlayersCommand(Locale locale, Addresses addresses, Processing processing) {
        super("players|pl|playerlist|list", Permissions.INSPECT_OTHER.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.addresses = addresses;
        this.processing = processing;
        this.setShortHelp(locale.getString(CmdHelpLang.PLAYERS));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.PLAYERS));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        this.processing.submitNonCritical(() -> this.sendListMsg(sender));
    }

    private void sendListMsg(Sender sender) {
        boolean console;
        sender.sendMessage(this.locale.getString(CommandLang.HEADER_PLAYERS));
        String address = this.addresses.getMainAddress().orElseGet(() -> {
            sender.sendMessage(this.locale.getString(CommandLang.NO_ADDRESS_NOTIFY));
            return this.addresses.getFallbackLocalhostAddress();
        });
        String url = address + "/players";
        String linkPrefix = this.locale.getString(CommandLang.LINK_PREFIX);
        boolean bl = console = !CommandUtils.isPlayer(sender);
        if (console) {
            sender.sendMessage(linkPrefix + url);
        } else {
            sender.sendMessage(linkPrefix);
            sender.sendLink("   ", this.locale.getString(CommandLang.LINK_CLICK_ME), url);
        }
        sender.sendMessage(">");
    }
}

