/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import plan.javax.inject.Inject;

public class ListServersCommand
extends CommandNode {
    private final Locale locale;
    private final ColorScheme colorScheme;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public ListServersCommand(Locale locale, ColorScheme colorScheme, DBSystem dbSystem, ErrorLogger errorLogger) {
        super("servers|serverlist|listservers|sl|ls", Permissions.MANAGE.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.colorScheme = colorScheme;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.SERVERS));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.SERVERS));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        String sCol = this.colorScheme.getSecondaryColor();
        String tCol = this.colorScheme.getTertiaryColor();
        Formatter<Server> serverFormatter = this.serverLister(sCol, tCol);
        try {
            sender.sendMessage(this.locale.getString(CommandLang.HEADER_SERVERS));
            this.sendServers(sender, serverFormatter);
            sender.sendMessage(">");
        }
        catch (DBOpException e) {
            sender.sendMessage("\u00a7cDatabase Exception occurred.");
            this.errorLogger.log(L.WARN, this.getClass(), e);
        }
    }

    private void sendServers(Sender sender, Formatter<Server> serverFormatter) {
        ArrayList<Server> servers = new ArrayList<Server>(this.dbSystem.getDatabase().query(ServerQueries.fetchPlanServerInformation()).values());
        Collections.sort(servers);
        for (Server server : servers) {
            sender.sendMessage((String)serverFormatter.apply(server));
        }
    }

    private Formatter<Server> serverLister(String tertiaryColor, String secondaryColor) {
        return server -> "  " + tertiaryColor + server.getId() + secondaryColor + " : " + server.getName() + " : " + server.getWebAddress();
    }
}

