/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.domain.mutators.GeoInfoMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.containers.ContainerFetchQueries;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class QInspectCommand
extends CommandNode {
    private final Locale locale;
    private final DBSystem dbSystem;
    private final PlanConfig config;
    private final Processing processing;
    private final Formatters formatters;
    private final UUIDUtility uuidUtility;
    private final ErrorLogger errorLogger;

    @Inject
    public QInspectCommand(PlanConfig config, Locale locale, Processing processing, DBSystem dbSystem, UUIDUtility uuidUtility, Formatters formatters, ErrorLogger errorLogger) {
        super("qinspect", Permissions.QUICK_INSPECT.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.config = config;
        this.processing = processing;
        this.formatters = formatters;
        this.setArguments("<player>");
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.uuidUtility = uuidUtility;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.QINSPECT));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.QINSPECT));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        String playerName = MiscUtils.getPlayerName(args, sender, Permissions.QUICK_INSPECT_OTHER);
        if (playerName == null) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_NO_PERMISSION));
            return;
        }
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        this.runInspectTask(playerName, sender);
    }

    private void runInspectTask(String playerName, Sender sender) {
        this.processing.submitNonCritical(() -> {
            try {
                UUID uuid = this.uuidUtility.getUUIDOf(playerName);
                if (uuid == null) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_USERNAME_NOT_VALID));
                    return;
                }
                PlayerContainer container = this.dbSystem.getDatabase().query(ContainerFetchQueries.fetchPlayerContainer(uuid));
                if (!container.getValue(PlayerKeys.REGISTERED).isPresent()) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_USERNAME_NOT_KNOWN));
                    return;
                }
                this.sendMessages(sender, container);
            }
            catch (DBOpException e) {
                sender.sendMessage("\u00a7eDatabase exception occurred: " + e.getMessage());
                this.errorLogger.log(L.WARN, this.getClass(), e);
            }
        });
    }

    private void sendMessages(Sender sender, PlayerContainer player) {
        long now = System.currentTimeMillis();
        Formatter<DateHolder> timestamp = this.formatters.year();
        Formatter<Long> length = this.formatters.timeAmount();
        String playerName = player.getValue(PlayerKeys.NAME).orElse(this.locale.getString(GenericLang.UNKNOWN));
        ActivityIndex activityIndex = player.getActivityIndex(now, this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD));
        Long registered = player.getValue(PlayerKeys.REGISTERED).orElse(0L);
        Long lastSeen = player.getValue(PlayerKeys.LAST_SEEN).orElse(0L);
        List geoInfo = player.getValue(PlayerKeys.GEO_INFO).orElse(new ArrayList());
        Optional<GeoInfo> mostRecentGeoInfo = new GeoInfoMutator(geoInfo).mostRecent();
        String geolocation = mostRecentGeoInfo.isPresent() ? mostRecentGeoInfo.get().getGeolocation() : "-";
        SessionsMutator sessionsMutator = SessionsMutator.forContainer(player);
        String[] messages = new String[]{this.locale.getString(CommandLang.HEADER_INSPECT, new Serializable[]{playerName}), this.locale.getString(CommandLang.QINSPECT_ACTIVITY_INDEX, new Serializable[]{activityIndex.getFormattedValue(this.formatters.decimals()), activityIndex.getGroup()}), this.locale.getString(CommandLang.QINSPECT_REGISTERED, (Serializable)timestamp.apply(() -> registered)), this.locale.getString(CommandLang.QINSPECT_LAST_SEEN, (Serializable)timestamp.apply(() -> lastSeen)), this.locale.getString(CommandLang.QINSPECT_GEOLOCATION, new Serializable[]{geolocation}), this.locale.getString(CommandLang.QINSPECT_TIMES_KICKED, player.getValue(PlayerKeys.KICK_COUNT).orElse(0)), "", this.locale.getString(CommandLang.QINSPECT_PLAYTIME, (Serializable)length.apply(sessionsMutator.toPlaytime())), this.locale.getString(CommandLang.QINSPECT_ACTIVE_PLAYTIME, (Serializable)length.apply(sessionsMutator.toActivePlaytime())), this.locale.getString(CommandLang.QINSPECT_AFK_PLAYTIME, (Serializable)length.apply(sessionsMutator.toAfkTime())), this.locale.getString(CommandLang.QINSPECT_LONGEST_SESSION, (Serializable)length.apply(sessionsMutator.toLongestSessionLength())), "", this.locale.getString(CommandLang.QINSPECT_PLAYER_KILLS, Integer.valueOf(sessionsMutator.toPlayerKillCount())), this.locale.getString(CommandLang.QINSPECT_MOB_KILLS, Integer.valueOf(sessionsMutator.toMobKillCount())), this.locale.getString(CommandLang.QINSPECT_DEATHS, Integer.valueOf(sessionsMutator.toDeathCount())), ">"};
        sender.sendMessage(messages);
    }
}

