/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.commands.Arguments;
import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.delivery.webserver.auth.RegistrationBin;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.storage.database.transactions.commands.RegisterWebUserTransaction;
import com.djrapitops.plan.utilities.PassEncryptUtil;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class RegisterCommand
extends CommandNode {
    private final String notEnoughArgsMsg;
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final UUIDUtility uuidUtility;
    private final Addresses addresses;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;

    @Inject
    public RegisterCommand(Locale locale, Processing processing, Addresses addresses, DBSystem dbSystem, UUIDUtility uuidUtility, PluginLogger logger, ErrorLogger errorLogger) {
        super("register", "", CommandType.ALL);
        this.locale = locale;
        this.processing = processing;
        this.addresses = addresses;
        this.uuidUtility = uuidUtility;
        this.logger = logger;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
        this.setArguments("<password>", "[name]", "[lvl]");
        this.setShortHelp(locale.getString(CmdHelpLang.WEB_REGISTER));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.WEB_REGISTER));
        this.notEnoughArgsMsg = locale.getString(CommandLang.FAIL_REQ_ARGS, new Serializable[]{Integer.valueOf(3), Arrays.toString(this.getArguments())});
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        try {
            Database.State dbState = this.dbSystem.getDatabase().getState();
            if (dbState != Database.State.OPEN) {
                sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
                return;
            }
            if (args.length == 0) {
                this.processing.submitNonCritical(() -> {
                    String url = this.addresses.getMainAddress().orElseGet(() -> {
                        sender.sendMessage(this.locale.getString(CommandLang.NO_ADDRESS_NOTIFY));
                        return this.addresses.getFallbackLocalhostAddress();
                    }) + "/register";
                    String linkPrefix = this.locale.getString(CommandLang.LINK_PREFIX);
                    sender.sendMessage(linkPrefix);
                    sender.sendLink("   ", this.locale.getString(CommandLang.LINK_CLICK_ME), url);
                });
                return;
            }
            Arguments arguments = new Arguments(args);
            Optional<String> code = arguments.getAfter("--code");
            if (code.isPresent()) {
                this.registerUsingCode(sender, code.get());
            } else {
                this.registerUsingLegacy(sender, arguments);
            }
        }
        catch (PassEncryptUtil.CannotPerformOperationException e) {
            this.errorLogger.log(L.WARN, this.getClass(), e);
            sender.sendMessage("\u00a7cPassword hash error.");
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(args[2]);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            this.errorLogger.log(L.WARN, this.getClass(), e);
        }
    }

    public void registerUsingCode(Sender sender, String code) {
        UUID linkedToUUID = CommandUtils.isPlayer(sender) ? this.uuidUtility.getUUIDOf(sender.getName()) : null;
        Optional<User> user = RegistrationBin.register(code, linkedToUUID);
        if (user.isPresent()) {
            this.registerUser(user.get(), sender, this.getPermissionLevel(sender));
        } else {
            sender.sendMessage("\u00a7c" + this.locale.getString(FailReason.USER_DOES_NOT_EXIST));
        }
    }

    public void registerUsingLegacy(Sender sender, Arguments arguments) {
        String password = arguments.get(0).orElseThrow(() -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ARGS, new Serializable[]{Integer.valueOf(1), Arrays.toString(this.getArguments())})));
        String passwordHash = PassEncryptUtil.createHash(password);
        int permissionLevel = arguments.getInteger(2).filter(arg -> sender.hasPermission(Permissions.MANAGE_WEB.getPerm())).orElseGet(() -> this.getPermissionLevel(sender));
        if (CommandUtils.isPlayer(sender)) {
            String playerName = sender.getName();
            UUID linkedToUUID = this.uuidUtility.getUUIDOf(playerName);
            String username = arguments.get(1).orElse(playerName);
            this.registerUser(new User(username, playerName, linkedToUUID, passwordHash, permissionLevel, Collections.emptyList()), sender, permissionLevel);
        } else {
            String username = arguments.get(1).orElseThrow(() -> new IllegalArgumentException(this.notEnoughArgsMsg));
            this.registerUser(new User(username, "console", null, passwordHash, permissionLevel, Collections.emptyList()), sender, permissionLevel);
        }
    }

    private int getPermissionLevel(Sender sender) {
        String permAnalyze = Permissions.ANALYZE.getPerm();
        String permInspectOther = Permissions.INSPECT_OTHER.getPerm();
        String permInspect = Permissions.INSPECT.getPerm();
        if (sender.hasPermission(permAnalyze)) {
            return 0;
        }
        if (sender.hasPermission(permInspectOther)) {
            return 1;
        }
        if (sender.hasPermission(permInspect)) {
            return 2;
        }
        return 100;
    }

    private void registerUser(User user, Sender sender, int permissionLevel) {
        this.processing.submitCritical(() -> {
            String username = user.getUsername();
            user.setPermissionLevel(permissionLevel);
            try {
                Database database = this.dbSystem.getDatabase();
                boolean userExists = database.query(WebUserQueries.fetchUser(username)).isPresent();
                if (userExists) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_WEB_USER_EXISTS));
                    return;
                }
                database.executeTransaction(new RegisterWebUserTransaction(user)).get();
                sender.sendMessage(this.locale.getString(CommandLang.WEB_USER_REGISTER_SUCCESS, new Serializable[]{username}));
                this.sendLink(sender);
                this.logger.info(this.locale.getString(CommandLang.WEB_USER_REGISTER_NOTIFY, new Serializable[]{username, Integer.valueOf(permissionLevel)}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (DBOpException | ExecutionException e) {
                this.errorLogger.log(L.WARN, this.getClass(), e);
            }
        });
    }

    private void sendLink(Sender sender) {
        boolean console;
        String url = this.addresses.getMainAddress().orElseGet(() -> {
            sender.sendMessage(this.locale.getString(CommandLang.NO_ADDRESS_NOTIFY));
            return this.addresses.getFallbackLocalhostAddress();
        });
        String linkPrefix = this.locale.getString(CommandLang.LINK_PREFIX);
        boolean bl = console = !CommandUtils.isPlayer(sender);
        if (console) {
            sender.sendMessage(linkPrefix + url);
        } else {
            sender.sendMessage(linkPrefix);
            sender.sendLink("   ", this.locale.getString(CommandLang.LINK_CLICK_ME), url);
        }
    }
}

