/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import plan.javax.inject.Inject;

public class ReloadCommand
extends CommandNode {
    private final PlanPlugin plugin;
    private final Locale locale;
    private final ErrorLogger errorLogger;

    @Inject
    public ReloadCommand(PlanPlugin plugin, Locale locale, ErrorLogger errorLogger) {
        super("reload", Permissions.RELOAD.getPermission(), CommandType.CONSOLE);
        this.plugin = plugin;
        this.locale = locale;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.RELOAD));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.RELOAD));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        new Thread(() -> {
            try {
                this.plugin.reloadPlugin(true);
                sender.sendMessage(this.locale.getString(CommandLang.RELOAD_COMPLETE));
            }
            catch (Exception e) {
                this.errorLogger.log(L.CRITICAL, this.getClass(), e);
                sender.sendMessage(this.locale.getString(CommandLang.RELOAD_FAILED));
            }
            finally {
                Thread thread = Thread.currentThread();
                thread.interrupt();
            }
        }, "Plan Reload Thread").start();
    }
}

