/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SearchCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public SearchCommand(Locale locale, Processing processing, DBSystem dbSystem, ErrorLogger errorLogger) {
        super("search", Permissions.SEARCH.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
        this.setArguments("<text>");
        this.setShortHelp(locale.getString(CmdHelpLang.SEARCH));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.SEARCH));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
        this.runSearchTask(args, sender);
    }

    private void runSearchTask(String[] args, Sender sender) {
        this.processing.submitNonCritical(() -> {
            try {
                String searchFor = args[0];
                List<String> names = this.dbSystem.getDatabase().query(UserIdentifierQueries.fetchMatchingPlayerNames(searchFor));
                Collections.sort(names);
                boolean empty = Verify.isEmpty(names);
                sender.sendMessage(this.locale.getString(CommandLang.HEADER_SEARCH, new Serializable[]{Integer.valueOf(empty ? 0 : names.size()), searchFor}));
                if (!empty) {
                    String message = names.toString();
                    sender.sendMessage(message.substring(1, message.length() - 1));
                }
                sender.sendMessage(">");
            }
            catch (DBOpException e) {
                sender.sendMessage("\u00a7cDatabase error occurred: " + e.getMessage());
                this.errorLogger.log(L.ERROR, this.getClass(), e);
            }
        });
    }
}

