/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands;

import com.djrapitops.plan.commands.Arguments;
import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.storage.database.transactions.commands.RemoveWebUserTransaction;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class UnregisterCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final UUIDUtility uuidUtility;
    private final ErrorLogger errorLogger;

    @Inject
    public UnregisterCommand(Locale locale, Processing processing, DBSystem dbSystem, UUIDUtility uuidUtility, ErrorLogger errorLogger) {
        super("unregister", "", CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.uuidUtility = uuidUtility;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.WEB_DELETE));
        this.setArguments("[username]");
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        Arguments arguments = new Arguments(args);
        Optional<String> givenUsername = arguments.get(0);
        this.processing.submitNonCritical(() -> {
            Database database = this.dbSystem.getDatabase();
            try {
                String username;
                Optional<User> found;
                UUID playerUUID;
                UUID uUID = playerUUID = CommandUtils.isPlayer(sender) ? this.uuidUtility.getUUIDOf(sender.getName()) : null;
                if (!givenUsername.isPresent() && playerUUID != null) {
                    found = database.query(WebUserQueries.fetchUser(playerUUID));
                    if (!found.isPresent()) {
                        sender.sendMessage("\u00a7c" + this.locale.getString(FailReason.USER_DOES_NOT_EXIST));
                        return;
                    }
                    username = found.get().getUsername();
                } else {
                    if (!givenUsername.isPresent()) {
                        sender.sendMessage("\u00a7c" + this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())}));
                        return;
                    }
                    username = (String)givenUsername.get();
                }
                found = database.query(WebUserQueries.fetchUser(username));
                if (!found.isPresent()) {
                    sender.sendMessage("\u00a7c" + this.locale.getString(FailReason.USER_DOES_NOT_EXIST));
                    return;
                }
                User presentUser = found.get();
                boolean linkedToSender = Objects.equals(playerUUID, presentUser.getLinkedToUUID());
                if (linkedToSender || sender.hasPermission(Permissions.MANAGE_WEB.getPerm())) {
                    this.deleteUser(sender, database, username);
                } else {
                    sender.sendMessage("\u00a7c" + this.locale.getString(CommandLang.USER_NOT_LINKED));
                }
            }
            catch (Exception e) {
                this.errorLogger.log(L.ERROR, this.getClass(), e);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            }
        });
    }

    private void deleteUser(Sender sender, Database database, String username) throws InterruptedException, ExecutionException {
        sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
        database.executeTransaction(new RemoveWebUserTransaction(username)).get();
        sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
    }
}

