/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.SQLiteDB;
import com.djrapitops.plan.storage.database.queries.ServerAggregateQueries;
import com.djrapitops.plan.storage.database.transactions.BackupCopyTransaction;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageBackupCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final SQLiteDB.Factory sqliteFactory;
    private final ErrorLogger errorLogger;
    private final Formatter<Long> iso8601LongFormatter;

    @Inject
    public ManageBackupCommand(Locale locale, Processing processing, DBSystem dbSystem, SQLiteDB.Factory sqliteFactory, Formatters formatters, ErrorLogger errorLogger) {
        super("backup", Permissions.MANAGE.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.sqliteFactory = sqliteFactory;
        this.errorLogger = errorLogger;
        this.iso8601LongFormatter = formatters.iso8601NoClockLong();
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_BACKUP));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_BACKUP));
        this.setArguments("<DB>");
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        try {
            Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
            String dbName = args[0].toLowerCase();
            boolean isCorrectDB = DBType.exists(dbName);
            Verify.isTrue(isCorrectDB, () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_INCORRECT_DB, new Serializable[]{dbName})));
            Database database = this.dbSystem.getActiveDatabaseByName(dbName);
            database.init();
            this.runBackupTask(sender, args, database);
        }
        catch (DBInitException e) {
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
        }
    }

    private void runBackupTask(Sender sender, String[] args, Database database) {
        this.processing.submitCritical(() -> {
            try {
                Database.State dbState = database.getState();
                if (dbState != Database.State.OPEN) {
                    sender.sendMessage(this.locale.getString(CommandLang.WARN_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
                }
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                this.createNewBackup(args[0], database);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
            }
            catch (Exception e) {
                this.errorLogger.log(L.ERROR, ManageBackupCommand.class, e);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewBackup(String dbName, Database copyFromDB) {
        Integer userCount = copyFromDB.query(ServerAggregateQueries.baseUserCount());
        if (userCount <= 0) {
            return;
        }
        try (Database backupDB = null;){
            String timeStamp = (String)this.iso8601LongFormatter.apply(System.currentTimeMillis());
            String fileName = dbName + "-backup-" + timeStamp;
            backupDB = this.sqliteFactory.usingFileCalled(fileName);
            backupDB.init();
            backupDB.executeTransaction(new BackupCopyTransaction(copyFromDB, backupDB)).get();
        }
    }
}

