/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.query.QuerySvc;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.commands.RemoveEverythingTransaction;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageClearCommand
extends CommandNode {
    private final PlanPlugin plugin;
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final QuerySvc queryService;
    private final ErrorLogger errorLogger;

    @Inject
    public ManageClearCommand(PlanPlugin plugin, Locale locale, Processing processing, DBSystem dbSystem, QuerySvc queryService, ErrorLogger errorLogger) {
        super("clear", Permissions.MANAGE.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.plugin = plugin;
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.queryService = queryService;
        this.errorLogger = errorLogger;
        this.setArguments("<DB>", "[-a]");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_CLEAR));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_CLEAR));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        String dbName = args[0].toLowerCase();
        boolean isCorrectDB = DBType.exists(dbName);
        Verify.isTrue(isCorrectDB, () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_INCORRECT_DB, new Serializable[]{dbName})));
        if (!Verify.contains("-a", args)) {
            sender.sendMessage(this.locale.getString(ManageLang.CONFIRMATION, new Serializable[]{this.locale.getString(ManageLang.CONFIRM_REMOVAL, new Serializable[]{dbName})}));
            return;
        }
        try {
            Database database = this.dbSystem.getActiveDatabaseByName(dbName);
            database.init();
            this.runClearTask(sender, database);
        }
        catch (DBInitException e) {
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
        }
    }

    private void runClearTask(Sender sender, Database database) {
        this.processing.submitCritical(() -> {
            try {
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                database.executeTransaction(new RemoveEverythingTransaction()).get();
                this.queryService.dataCleared();
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
                this.reloadPlugin(sender);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (DBOpException | ExecutionException e) {
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
                this.errorLogger.log(L.ERROR, this.getClass(), e);
            }
        });
    }

    private void reloadPlugin(Sender sender) {
        try {
            this.plugin.reloadPlugin(true);
        }
        catch (Exception e) {
            this.errorLogger.log(L.CRITICAL, this.getClass(), e);
            sender.sendMessage(this.locale.getString(CommandLang.RELOAD_FAILED));
        }
        sender.sendMessage(this.locale.getString(CommandLang.RELOAD_COMPLETE));
    }
}

