/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.gathering.listeners.Status;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import plan.javax.inject.Inject;

public class ManageDisableCommand
extends CommandNode {
    private final Locale locale;
    private final Status status;

    @Inject
    public ManageDisableCommand(Locale locale, Status status) {
        super("disable", Permissions.MANAGE.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.status = status;
        this.setArguments("<feature>");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_DISABLE));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_DISABLE));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        if ("kickcount".equalsIgnoreCase(args[0])) {
            this.status.setCountKicks(false);
            sender.sendMessage(this.locale.getString(CommandLang.FEATURE_DISABLED, new Serializable[]{"Kick Counting"}));
        } else {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_NO_SUCH_FEATURE, new Serializable[]{"'kickcount'"}));
        }
    }
}

