/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.delivery.export.Exporter;
import com.djrapitops.plan.exceptions.ExportException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageExportCommand
extends CommandNode {
    private final Locale locale;
    private final ColorScheme colorScheme;
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Exporter exporter;
    private final Processing processing;

    @Inject
    public ManageExportCommand(Locale locale, ColorScheme colorScheme, PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, Exporter exporter, Processing processing) {
        super("export", Permissions.MANAGE.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.colorScheme = colorScheme;
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.exporter = exporter;
        this.processing = processing;
        this.setArguments("<export_kind>/list");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_EXPORT));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_EXPORT));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ARGS, new Serializable[]{"1+", Arrays.toString(this.getArguments())})));
        String exportArg = args[0];
        if ("list".equals(exportArg)) {
            sender.sendMessage("> " + this.colorScheme.getMainColor() + "players, server_json");
            return;
        }
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        this.getExportFunction(exportArg).accept(sender);
    }

    private Consumer<Sender> getExportFunction(String exportArg) {
        if ("players".equals(exportArg)) {
            return this::exportPlayers;
        }
        if ("server_json".endsWith(exportArg)) {
            return this::exportServerJSON;
        }
        return sender -> sender.sendMessage(this.locale.getString(ManageLang.FAIL_EXPORTER_NOT_FOUND, new Serializable[]{exportArg}));
    }

    private void exportServerJSON(Sender sender) {
        if (this.config.isFalse(ExportSettings.SERVER_JSON)) {
            sender.sendMessage("\u00a7c'" + ExportSettings.SERVER_JSON.getPath() + "': false");
            return;
        }
        this.processing.submitNonCritical(() -> {
            try {
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                if (this.exporter.exportServerJSON(this.serverInfo.getServer())) {
                    sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
                } else {
                    sender.sendMessage(this.locale.get(ManageLang.PROGRESS_FAIL).toString(new Serializable[]{"see '" + ExportSettings.SERVER_JSON.getPath() + "' in config.yml"}));
                }
            }
            catch (ExportException e) {
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL));
                sender.sendMessage("\u00a7c" + e.toString());
            }
        });
    }

    private void exportPlayers(Sender sender) {
        boolean exportPlayerJSON = this.config.isTrue(ExportSettings.PLAYER_JSON);
        boolean exportPlayerHTML = this.config.isTrue(ExportSettings.PLAYER_PAGES);
        boolean exportPlayersHtml = this.config.isTrue(ExportSettings.PLAYERS_PAGE);
        if (!exportPlayerJSON && !exportPlayerHTML) {
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL));
            sender.sendMessage("\u00a7c'" + ExportSettings.PLAYER_JSON.getPath() + "' & '" + ExportSettings.PLAYER_PAGES.getPath() + "': false");
            return;
        }
        if (exportPlayersHtml) {
            this.processing.submitNonCritical(this.exporter::exportPlayersPage);
        }
        this.processing.submitNonCritical(() -> this.performExport(sender, exportPlayerJSON, exportPlayerHTML));
    }

    private void performExport(Sender sender, boolean exportPlayerJSON, boolean exportPlayerHTML) {
        sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
        Map<UUID, String> players = this.dbSystem.getDatabase().query(UserIdentifierQueries.fetchAllPlayerNames());
        int size = players.size();
        int failed = 0;
        int i = 1;
        for (Map.Entry<UUID, String> entry : players.entrySet()) {
            try {
                if (exportPlayerJSON) {
                    this.exporter.exportPlayerJSON(entry.getKey(), entry.getValue());
                }
                if (exportPlayerHTML) {
                    this.exporter.exportPlayerPage(entry.getKey(), entry.getValue());
                }
            }
            catch (ExportException e) {
                ++failed;
            }
            if (++i % 1000 != 0) continue;
            sender.sendMessage(i + " / " + size + " processed..");
        }
        sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
        if (failed != 0) {
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL));
            sender.sendMessage(" \u00a72\u2714: \u00a7f" + (i - failed));
            sender.sendMessage(" \u00a7c\u2715: \u00a7f" + failed);
        }
    }
}

