/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DatabaseSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import plan.javax.inject.Inject;

public class ManageHotSwapCommand
extends CommandNode {
    private final PlanPlugin plugin;
    private final Locale locale;
    private final DBSystem dbSystem;
    private final PlanConfig config;
    private final ErrorLogger errorLogger;

    @Inject
    public ManageHotSwapCommand(PlanPlugin plugin, Locale locale, DBSystem dbSystem, PlanConfig config, ErrorLogger errorLogger) {
        super("hotswap", Permissions.MANAGE.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.plugin = plugin;
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.config = config;
        this.errorLogger = errorLogger;
        this.setArguments("<DB>");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_HOTSWAP));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        String dbName = args[0].toLowerCase();
        boolean isCorrectDB = DBType.exists(dbName);
        Verify.isTrue(isCorrectDB, () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_INCORRECT_DB, new Serializable[]{dbName})));
        Verify.isFalse(dbName.equals(this.dbSystem.getDatabase().getType().getConfigName()), () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_SAME_DB)));
        try {
            Database database = this.dbSystem.getActiveDatabaseByName(dbName);
            database.init();
            if (database.getState() == Database.State.CLOSED) {
                return;
            }
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, this.getClass(), e);
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            return;
        }
        try {
            this.config.set(DatabaseSettings.TYPE, dbName);
            this.config.save();
        }
        catch (IOException e) {
            this.errorLogger.log(L.ERROR, this.getClass(), e);
            return;
        }
        this.plugin.reloadPlugin(true);
    }
}

