/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.gathering.importing.ImportSystem;
import com.djrapitops.plan.gathering.importing.importers.Importer;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageImportCommand
extends CommandNode {
    private final Locale locale;
    private final DBSystem dbSystem;
    private final Processing processing;
    private final ImportSystem importSystem;

    @Inject
    public ManageImportCommand(Locale locale, DBSystem dbSystem, Processing processing, ImportSystem importSystem) {
        super("import", Permissions.MANAGE.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.processing = processing;
        this.importSystem = importSystem;
        this.setArguments("<plugin>/list", "[import args]");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_IMPORT));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_IMPORT));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ARGS, new Serializable[]{"1+", Arrays.toString(this.getArguments())})));
        String importArg = args[0];
        if ("list".equals(importArg)) {
            sender.sendMessage(this.locale.getString(ManageLang.IMPORTERS));
            this.importSystem.getImporterNames().forEach(name -> sender.sendMessage("- " + name));
            return;
        }
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        this.findAndProcessImporter(sender, importArg);
    }

    private void findAndProcessImporter(Sender sender, String importArg) {
        Optional<Importer> foundImporter = this.importSystem.getImporter(importArg);
        if (foundImporter.isPresent()) {
            Importer importer = foundImporter.get();
            this.processing.submitNonCritical(() -> {
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                importer.processImport();
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
            });
        } else {
            sender.sendMessage(this.locale.getString(ManageLang.FAIL_IMPORTER_NOT_FOUND, new Serializable[]{importArg}));
        }
    }
}

