/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.BackupCopyTransaction;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageMoveCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public ManageMoveCommand(Locale locale, Processing processing, DBSystem dbSystem, ErrorLogger errorLogger) {
        super("move", Permissions.MANAGE.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
        this.setArguments("<fromDB>", "<toDB>", "[-a]");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_MOVE));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_MOVE));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 2, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ARGS, new Serializable[]{Integer.valueOf(2), Arrays.toString(this.getArguments())})));
        DBType fromDB = DBType.getForName(args[0]).orElseThrow(() -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_INCORRECT_DB, new Serializable[]{args[0]})));
        DBType toDB = DBType.getForName(args[1]).orElseThrow(() -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_INCORRECT_DB, new Serializable[]{args[1]})));
        Verify.isFalse(fromDB == toDB, () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_SAME_DB)));
        if (!Verify.contains("-a", args)) {
            sender.sendMessage(this.locale.getString(ManageLang.CONFIRMATION, new Serializable[]{this.locale.getString(ManageLang.CONFIRM_OVERWRITE, new Serializable[]{toDB.getConfigName()})}));
            return;
        }
        try {
            Database fromDatabase = this.dbSystem.getActiveDatabaseByType(fromDB);
            Database toDatabase = this.dbSystem.getActiveDatabaseByType(toDB);
            fromDatabase.init();
            toDatabase.init();
            this.runMoveTask(fromDatabase, toDatabase, sender);
        }
        catch (Exception e) {
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
        }
    }

    private void runMoveTask(Database fromDatabase, Database toDatabase, Sender sender) {
        this.processing.submitCritical(() -> {
            try {
                boolean movingToCurrentDB;
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                toDatabase.executeTransaction(new BackupCopyTransaction(fromDatabase, toDatabase)).get();
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
                boolean bl = movingToCurrentDB = toDatabase.getType() == this.dbSystem.getDatabase().getType();
                if (movingToCurrentDB) {
                    sender.sendMessage(this.locale.getString(ManageLang.HOTSWAP_REMINDER, new Serializable[]{toDatabase.getType().getConfigName()}));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.errorLogger.log(L.ERROR, this.getClass(), e);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            }
        });
    }
}

