/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import plan.javax.inject.Inject;

public class ManageRawDataCommand
extends CommandNode {
    private final Locale locale;
    private final Addresses addresses;
    private final Processing processing;

    @Inject
    public ManageRawDataCommand(Locale locale, Addresses addresses, Processing processing) {
        super("raw", Permissions.MANAGE.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.addresses = addresses;
        this.processing = processing;
        this.setArguments("<player>");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_RAW_DATA));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_RAW_DATA));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        this.processing.submitNonCritical(() -> {
            boolean console;
            String playerName = MiscUtils.getPlayerName(args, sender, Permissions.MANAGE);
            sender.sendMessage(this.locale.getString(CommandLang.HEADER_INSPECT, new Serializable[]{playerName}));
            String address = this.addresses.getMainAddress().orElseGet(() -> {
                sender.sendMessage(this.locale.getString(CommandLang.NO_ADDRESS_NOTIFY));
                return this.addresses.getFallbackLocalhostAddress();
            });
            String url = address + "/player/" + Html.encodeToURL(playerName) + "/raw";
            String linkPrefix = this.locale.getString(CommandLang.LINK_PREFIX);
            boolean bl = console = !CommandUtils.isPlayer(sender);
            if (console) {
                sender.sendMessage(linkPrefix + url);
            } else {
                sender.sendMessage(linkPrefix);
                sender.sendLink("   ", this.locale.getString(CommandLang.LINK_CLICK_ME), url);
            }
            sender.sendMessage(">");
        });
    }
}

