/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.UUIDUtility;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.query.QuerySvc;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import com.djrapitops.plan.storage.database.transactions.commands.RemovePlayerTransaction;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageRemoveCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final QuerySvc queryService;
    private final UUIDUtility uuidUtility;
    private final ErrorLogger errorLogger;

    @Inject
    public ManageRemoveCommand(Locale locale, Processing processing, DBSystem dbSystem, QuerySvc queryService, UUIDUtility uuidUtility, ErrorLogger errorLogger) {
        super("remove|delete", Permissions.MANAGE.getPermission(), CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.queryService = queryService;
        this.uuidUtility = uuidUtility;
        this.errorLogger = errorLogger;
        this.setArguments("<player>", "[-a]");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_REMOVE));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_REMOVE));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        String playerName = MiscUtils.getPlayerName(args, sender, Permissions.MANAGE);
        if (playerName == null) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_NO_PERMISSION));
            return;
        }
        this.runRemoveTask(playerName, sender, args);
    }

    private void runRemoveTask(String playerName, Sender sender, String[] args) {
        this.processing.submitCritical(() -> {
            try {
                UUID playerUUID = this.uuidUtility.getUUIDOf(playerName);
                if (playerUUID == null) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_USERNAME_NOT_VALID));
                    return;
                }
                Database db = this.dbSystem.getDatabase();
                if (!db.query(PlayerFetchQueries.isPlayerRegistered(playerUUID)).booleanValue()) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_USERNAME_NOT_KNOWN));
                    return;
                }
                if (!Verify.contains("-a", args)) {
                    sender.sendMessage(this.locale.getString(ManageLang.CONFIRMATION, new Serializable[]{this.locale.getString(ManageLang.CONFIRM_REMOVAL, new Serializable[]{db.getType().getName()})}));
                    return;
                }
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                this.queryService.playerRemoved(playerUUID);
                db.executeTransaction(new RemovePlayerTransaction(playerUUID)).get();
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (DBOpException | ExecutionException e) {
                this.errorLogger.log(L.ERROR, this.getClass(), e);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            }
        });
    }
}

