/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.SQLiteDB;
import com.djrapitops.plan.storage.database.transactions.BackupCopyTransaction;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import plan.javax.inject.Inject;

public class ManageRestoreCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;
    private final SQLiteDB.Factory sqliteFactory;
    private final PlanFiles files;

    @Inject
    public ManageRestoreCommand(Locale locale, Processing processing, DBSystem dbSystem, SQLiteDB.Factory sqliteFactory, PlanFiles files, ErrorLogger errorLogger) {
        super("restore", Permissions.MANAGE.getPermission(), CommandType.CONSOLE);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.sqliteFactory = sqliteFactory;
        this.files = files;
        this.errorLogger = errorLogger;
        this.setArguments("<Filename.db>", "<dbTo>", "[-a]");
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_RESTORE));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_RESTORE));
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Verify.isTrue(args.length >= 2, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ARGS, new Serializable[]{Integer.valueOf(2), Arrays.toString(this.getArguments())})));
        String backupDbName = args[0];
        String dbName = args[1].toLowerCase();
        boolean isCorrectDB = DBType.exists(dbName);
        Verify.isTrue(isCorrectDB, () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_INCORRECT_DB, new Serializable[]{dbName})));
        try {
            Database database = this.dbSystem.getActiveDatabaseByName(dbName);
            Verify.isFalse(backupDbName.contains("database") && database instanceof SQLiteDB, () -> new IllegalArgumentException(this.locale.getString(ManageLang.FAIL_SAME_DB)));
            database.init();
            if (!Verify.contains("-a", args)) {
                sender.sendMessage(this.locale.getString(ManageLang.CONFIRMATION, new Serializable[]{this.locale.getString(ManageLang.CONFIRM_OVERWRITE, new Serializable[]{database.getType().getName()})}));
                return;
            }
            this.runRestoreTask(backupDbName, sender, database);
        }
        catch (Exception e) {
            sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
        }
    }

    private void runRestoreTask(String backupDbName, Sender sender, Database database) {
        this.processing.submitCritical(() -> {
            try {
                boolean containsDBFileExtension = backupDbName.endsWith(".db");
                File backupDBFile = this.files.getFileFromPluginFolder(backupDbName + (containsDBFileExtension ? "" : ".db"));
                if (!backupDBFile.exists()) {
                    sender.sendMessage(this.locale.getString(ManageLang.FAIL_FILE_NOT_FOUND, new Serializable[]{backupDBFile.getAbsolutePath()}));
                    return;
                }
                SQLiteDB backupDB = this.sqliteFactory.usingFile(backupDBFile);
                backupDB.init();
                Database.State dbState = database.getState();
                if (dbState != Database.State.OPEN) {
                    sender.sendMessage(this.locale.getString(CommandLang.WARN_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
                }
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
                database.executeTransaction(new BackupCopyTransaction(backupDB, database)).get();
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.errorLogger.log(L.ERROR, this.getClass(), e);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            }
        });
    }
}

