/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.manage;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.transactions.commands.SetServerAsUninstalledTransaction;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ManageUninstalledCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;
    private final ServerInfo serverInfo;

    @Inject
    public ManageUninstalledCommand(Locale locale, Processing processing, DBSystem dbSystem, ServerInfo serverInfo, ErrorLogger errorLogger) {
        super("uninstalled", Permissions.MANAGE.getPermission(), CommandType.ALL_WITH_ARGS);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.MANAGE_UNINSTALLED));
        this.setInDepthHelp(locale.getArray(DeepHelpLang.MANAGE_UNINSTALLED));
        this.setArguments("[server/id]");
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_START));
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        this.processing.submitNonCritical(() -> {
            try {
                Optional<Server> serverOptional = this.getServer(args);
                if (!serverOptional.isPresent()) {
                    sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{this.locale.getString(ManageLang.NO_SERVER)}));
                    return;
                }
                Server server = serverOptional.get();
                UUID serverUUID = server.getUuid();
                if (this.serverInfo.getServerUUID().equals(serverUUID)) {
                    sender.sendMessage(this.locale.getString(ManageLang.UNINSTALLING_SAME_SERVER));
                    return;
                }
                this.dbSystem.getDatabase().executeTransaction(new SetServerAsUninstalledTransaction(serverUUID));
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_SUCCESS));
            }
            catch (DBOpException e) {
                sender.sendMessage("\u00a7cError occurred: " + e.toString());
                this.errorLogger.log(L.ERROR, this.getClass(), e);
            }
        });
    }

    private Optional<Server> getServer(String[] args) {
        if (args.length >= 1) {
            String serverIdentifier = this.getGivenIdentifier(args);
            return this.dbSystem.getDatabase().query(ServerQueries.fetchServerMatchingIdentifier(serverIdentifier)).filter(Server::isNotProxy);
        }
        return Optional.empty();
    }

    private String getGivenIdentifier(String[] args) {
        StringBuilder idBuilder = new StringBuilder(args[0]);
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                idBuilder.append(" ").append(args[i]);
            }
        }
        return idBuilder.toString();
    }
}

