/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.commands.subcommands.webuser;

import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class WebCheckCommand
extends CommandNode {
    private final Locale locale;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public WebCheckCommand(Locale locale, Processing processing, DBSystem dbSystem, ErrorLogger errorLogger) {
        super("check", Permissions.MANAGE_WEB.getPerm(), CommandType.PLAYER_OR_ARGS);
        this.locale = locale;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
        this.setShortHelp(locale.getString(CmdHelpLang.WEB_CHECK));
        this.setArguments("<username>");
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            sender.sendMessage(this.locale.getString(CommandLang.FAIL_DATABASE_NOT_OPEN, new Serializable[]{dbState.name()}));
            return;
        }
        Verify.isTrue(args.length >= 1, () -> new IllegalArgumentException(this.locale.getString(CommandLang.FAIL_REQ_ONE_ARG, new Serializable[]{Arrays.toString(this.getArguments())})));
        String user = args[0];
        this.processing.submitNonCritical(() -> {
            try {
                Database db = this.dbSystem.getDatabase();
                Optional<User> found = db.query(WebUserQueries.fetchUser(user));
                if (!found.isPresent()) {
                    sender.sendMessage(this.locale.getString(CommandLang.FAIL_WEB_USER_NOT_EXISTS));
                    return;
                }
                User info = found.get();
                sender.sendMessage(this.locale.getString(CommandLang.WEB_USER_LIST, new Serializable[]{info.getUsername(), Integer.valueOf(info.getPermissionLevel())}));
            }
            catch (Exception e) {
                this.errorLogger.log(L.ERROR, this.getClass(), e);
                sender.sendMessage(this.locale.getString(ManageLang.PROGRESS_FAIL, new Serializable[]{e.getMessage()}));
            }
        });
    }
}

