/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.data.element;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plugin.utilities.ArrayUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class TableContainer {
    protected final String[] header;
    protected final Formatter[] formatters;
    private final List<Serializable[]> values;
    private String jqueryDatatable;
    private String color;

    public TableContainer(String ... header) {
        this.header = header;
        this.formatters = new Formatter[this.header.length];
        this.values = new ArrayList<Serializable[]>();
    }

    public TableContainer(boolean players, String ... header) {
        this(ArrayUtil.merge({Icon.called("user").build() + " Player"}, header));
    }

    public final void addRow(Serializable ... values) {
        this.values.add(values);
    }

    public String parsehtml() {
        return this.buildHtml();
    }

    public String buildHtml() {
        return this.getTableHeader() + this.parseHeader() + this.parseBody() + "</table></div>";
    }

    public final String parseBody() {
        if (this.values.isEmpty()) {
            this.addRow(new Serializable[]{"No Data"});
        }
        return "<tbody>" + this.buildBody() + "</tbody>";
    }

    private String buildBody() {
        StringBuilder body = new StringBuilder();
        for (Serializable[] row : this.values) {
            this.appendRow(body, row);
        }
        return body.toString();
    }

    private void appendRow(StringBuilder body, Serializable[] row) {
        int maxIndex = row.length - 1;
        body.append("<tr>");
        for (int i = 0; i < this.header.length; ++i) {
            try {
                if (i > maxIndex) {
                    body.append("<td>-");
                } else {
                    this.appendValue(body, row[i], this.formatters[i]);
                }
                body.append("</td>");
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
                throw new IllegalStateException("Invalid formatter given at index " + i + ": " + e.getMessage(), e);
            }
        }
        body.append("</tr>");
    }

    private void appendValue(StringBuilder body, Serializable value, Formatter formatter) {
        body.append("<td").append(formatter != null ? " data-order=\"" + value + "\">" : ">");
        if (formatter != null) {
            body.append(formatter.apply(value));
        } else {
            body.append(value != null ? value : Character.valueOf('-'));
        }
    }

    public final void setColor(String color) {
        this.color = color;
    }

    public final String parseHeader() {
        StringBuilder parsedHeader = new StringBuilder("<thead" + (this.color != null ? " class=\"bg-" + this.color + "\"" : "") + "><tr>");
        for (String title : this.header) {
            parsedHeader.append("<th>").append(title).append("</th>");
        }
        parsedHeader.append("</tr></thead>");
        return parsedHeader.toString();
    }

    public final void setFormatter(int index, Formatter formatter) {
        if (index < this.formatters.length) {
            this.formatters[index] = formatter;
        }
    }

    public void useJqueryDataTables() {
        this.jqueryDatatable = "player-plugin-table";
    }

    public void useJqueryDataTables(String sortType) {
        this.jqueryDatatable = sortType;
    }

    private String getTableHeader() {
        if (this.jqueryDatatable != null) {
            return "<div class=\"table-responsive\"><table class=\"table table-bordered table-striped table-hover " + this.jqueryDatatable + " dataTable\">";
        }
        return "<div class=\"scrollbar\"><table class=\"table table-striped\">";
    }
}

