/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain;

import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.gathering.domain.BaseUser;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class TablePlayer
implements Comparable<TablePlayer> {
    private UUID uuid;
    private String name;
    private ActivityIndex activityIndex;
    private Long playtime;
    private Integer sessionCount;
    private Long registered;
    private Long lastSeen;
    private String geolocation;
    private boolean banned = false;

    private TablePlayer() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromBaseUser(BaseUser baseUser) {
        return new Builder().uuid(baseUser.getUuid()).name(baseUser.getName()).registered(baseUser.getRegistered());
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<ActivityIndex> getCurrentActivityIndex() {
        return Optional.ofNullable(this.activityIndex);
    }

    public Optional<Long> getPlaytime() {
        return Optional.ofNullable(this.playtime);
    }

    public Optional<Integer> getSessionCount() {
        return Optional.ofNullable(this.sessionCount);
    }

    public Optional<Long> getRegistered() {
        return Optional.ofNullable(this.registered);
    }

    public Optional<Long> getLastSeen() {
        return Optional.ofNullable(this.lastSeen);
    }

    public Optional<String> getGeolocation() {
        return Optional.ofNullable(this.geolocation);
    }

    public boolean isBanned() {
        return this.banned;
    }

    @Override
    public int compareTo(TablePlayer other) {
        return Long.compare(other.lastSeen != null ? other.lastSeen : 0L, this.lastSeen != null ? this.lastSeen : 0L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TablePlayer)) {
            return false;
        }
        TablePlayer that = (TablePlayer)o;
        return this.playtime.equals(that.playtime) && this.sessionCount.equals(that.sessionCount) && this.registered.equals(that.registered) && this.lastSeen.equals(that.lastSeen) && this.name.equals(that.name) && this.activityIndex.equals(that.activityIndex) && this.geolocation.equals(that.geolocation);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.activityIndex, this.playtime, this.sessionCount, this.registered, this.lastSeen, this.geolocation);
    }

    public String toString() {
        return "TablePlayer{uuid=" + this.uuid + ", name='" + this.name + '\'' + ", activityIndex=" + this.activityIndex + ", playtime=" + this.playtime + ", sessionCount=" + this.sessionCount + ", registered=" + this.registered + ", lastSeen=" + this.lastSeen + ", geolocation='" + this.geolocation + '\'' + ", banned=" + this.banned + '}';
    }

    public static class Builder {
        private final TablePlayer player = new TablePlayer();

        public UUID getPlayerUUID() {
            return this.player.uuid;
        }

        public Builder uuid(UUID playerUUID) {
            this.player.uuid = playerUUID;
            return this;
        }

        public Builder name(String name) {
            this.player.name = name;
            return this;
        }

        public Builder banned() {
            this.player.banned = true;
            return this;
        }

        public Builder activityIndex(ActivityIndex activityIndex) {
            this.player.activityIndex = activityIndex;
            return this;
        }

        public Builder playtime(long playtime) {
            this.player.playtime = playtime;
            return this;
        }

        public Builder sessionCount(int count) {
            this.player.sessionCount = count;
            return this;
        }

        public Builder registered(long registered) {
            this.player.registered = registered;
            return this;
        }

        public Builder lastSeen(long lastSeen) {
            this.player.lastSeen = lastSeen;
            return this;
        }

        public Builder geolocation(String geolocation) {
            this.player.geolocation = geolocation;
            return this;
        }

        public TablePlayer build() {
            return this.player;
        }
    }
}

