/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.auth;

import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.utilities.PassEncryptUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;

public class User {
    private final String username;
    private final String linkedTo;
    private final UUID linkedToUUID;
    private final String passwordHash;
    private int permissionLevel;
    private final Collection<String> permissions;

    public User(String username, String linkedTo, UUID linkedToUUID, String passwordHash, int permissionLevel, Collection<String> permissions) {
        this.username = username;
        this.linkedTo = linkedTo;
        this.linkedToUUID = linkedToUUID;
        this.passwordHash = passwordHash;
        this.permissionLevel = permissionLevel;
        this.permissions = permissions;
    }

    public boolean doesPasswordMatch(String password) {
        return PassEncryptUtil.verifyPassword(password, this.passwordHash);
    }

    public WebUser toWebUser() {
        return new WebUser(this.linkedTo, this.username, this.permissions);
    }

    public String getUsername() {
        return this.username;
    }

    public String getLinkedTo() {
        return this.linkedTo;
    }

    public UUID getLinkedToUUID() {
        return this.linkedToUUID;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Deprecated
    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    @Deprecated
    public void setPermissionLevel(int permissionLevel) {
        this.permissionLevel = permissionLevel;
    }

    public String toString() {
        return "User{username='" + this.username + '\'' + ", linkedTo='" + this.linkedTo + '\'' + ", linkedToUUID=" + this.linkedToUUID + ", passwordHash='" + this.passwordHash + '\'' + ", permissionLevel=" + this.permissionLevel + ", permissions=" + this.permissions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.permissionLevel == user.permissionLevel && Objects.equals(this.username, user.username) && Objects.equals(this.linkedTo, user.linkedTo) && Objects.equals(this.linkedToUUID, user.linkedToUUID) && Objects.equals(this.passwordHash, user.passwordHash) && Objects.equals(this.permissions, user.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.linkedTo, this.linkedToUUID, this.passwordHash, this.permissionLevel, this.permissions);
    }
}

