/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.container;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class CachingSupplier<T>
implements Supplier<T> {
    private final Supplier<T> original;
    private T cachedValue;
    private long cacheTime;
    private final long timeToLive;

    public CachingSupplier(Supplier<T> original) {
        this(original, TimeUnit.SECONDS.toMillis(30L));
    }

    public CachingSupplier(Supplier<T> original, long timeToLive) {
        this.original = original;
        this.timeToLive = timeToLive;
        this.cacheTime = 0L;
    }

    @Override
    public T get() {
        if (this.cachedValue == null || System.currentTimeMillis() - this.cacheTime > this.timeToLive) {
            this.cachedValue = this.original.get();
            this.cacheTime = System.currentTimeMillis();
        }
        return this.cachedValue;
    }
}

