/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.domain.container;

import com.djrapitops.plan.delivery.domain.keys.Key;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public interface DataContainer {
    default public Map<String, Object> mapToNormalMap() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.getMap().forEach((key, value) -> {
            if (value instanceof DataContainer) {
                value = ((DataContainer)value).mapToNormalMap();
            }
            if (value instanceof Map) {
                value = this.handleMap((Map<?, ?>)value);
            }
            if (value instanceof List) {
                value = this.handleList((List)value);
            }
            values.put(key.getKeyName(), value);
        });
        return values;
    }

    default public List<?> handleList(List<?> list) {
        if (list.stream().findAny().orElse(null) instanceof DataContainer) {
            return Lists.map(list, obj -> ((DataContainer)obj).mapToNormalMap());
        }
        return list;
    }

    default public Map<?, ?> handleMap(Map<?, ?> map) {
        if (map.values().stream().findAny().orElse(null) instanceof DataContainer) {
            HashMap newMap = new HashMap();
            map.forEach((key, value) -> newMap.put(key, ((DataContainer)value).mapToNormalMap()));
            return newMap;
        }
        return map;
    }

    public <T> void putRawData(Key<T> var1, T var2);

    public <T> void putSupplier(Key<T> var1, Supplier<T> var2);

    public <T> void putCachingSupplier(Key<T> var1, Supplier<T> var2);

    public <T> boolean supports(Key<T> var1);

    public <T> Optional<T> getValue(Key<T> var1);

    public <T> T getUnsafe(Key<T> var1);

    default public <T> String getFormatted(Key<T> key, Formatter<Optional<T>> formatter) {
        Optional<T> value = this.getValue(key);
        return (String)formatter.apply(value);
    }

    default public <T> String getFormattedUnsafe(Key<T> key, Formatter<T> formatter) {
        T value = this.getUnsafe(key);
        return (String)formatter.apply(value);
    }

    public void putAll(DataContainer var1);

    public void clear();

    public Map<Key, Object> getMap();
}

